/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.path;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.GeodeticCalculator;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import ru.concel.routing.astar.path.Point;

public class Segment {
    private String tr;
    private Point[] pn;
    private Map<String, String> tg;
    private double l;
    private long typeID;
    private Feature line;
    private static GeodeticCalculator gc = new GeodeticCalculator();
    private static GeometryFactory gf = new GeometryFactory();
    private static long s_count = 0L;

    public long getTypeID() {
        return this.typeID;
    }

    public void setTypeID(long typeID) {
        this.typeID = typeID;
    }

    public Segment(String type, Long typeID, Point[] points, Map<String, String> tags) throws Exception {
        this.typeID = typeID;
        this.tr = type;
        this.setPoints(points);
        this.setTags(tags);
    }

    public String getType() {
        return this.tr;
    }

    public void setType(String type) {
        this.tr = type;
    }

    public Point[] getPoints() {
        return this.pn;
    }

    public void setPoints(Point[] points) throws SchemaException {
        this.pn = points;
        this.l = Arrays.stream(points).skip(1L).reduce(new Point(points[0].getCr(), 0.0, 0.0, new HashMap<String, String>()), (d, p) -> {
            Coordinate dc = d.getCoordinate();
            Coordinate pc = p.getCoordinate();
            gc.setStartingGeographicPoint(dc.x, dc.y);
            gc.setDestinationGeographicPoint(pc.x, pc.y);
            d.setAr(d.getAr() + gc.getOrthodromicDistance());
            d.setCr(p.getCr());
            return d;
        }).getAr();
        String type = "LineString";
        SimpleFeatureType pathFType = DataUtilities.createType((String)"Path", (String)("geom:" + type + ":srid=4326,name:String"));
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(pathFType);
        builder.add((Object)gf.createLineString((Coordinate[])Arrays.stream(points).map(p -> p.getCoordinate()).toArray(Coordinate[]::new)));
        builder.add((Object)this.getType());
        this.line = builder.buildFeature("S" + s_count++);
    }

    public Map<String, String> getTags() {
        return this.tg;
    }

    public void setTags(Map<String, String> tags) {
        this.tg = new HashMap<String, String>();
        tags.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("start:")).map(e -> {
            String[] stringArray;
            if ("infor_route_key".equals(e.getKey())) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = (String)e.getKey();
                stringArray = stringArray2;
                stringArray2[1] = ((String)e.getValue()).substring(0, ((String)e.getValue()).lastIndexOf("_"));
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = (String)e.getKey();
                stringArray = stringArray3;
                stringArray3[1] = (String)e.getValue();
            }
            return stringArray;
        }).forEach(e -> this.tg.put(e[0], e[1]));
    }

    public double getL() {
        return this.l;
    }

    public void setL(double length) {
        this.l = length;
    }

    public Feature getLine() {
        return this.line;
    }

    public void setLine(Feature line) {
        this.line = line;
    }
}

