/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.transport;

import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.fitness.TravelTime;
import ru.concel.routing.astar.transport.LinkParameters;
import ru.concel.routing.astar.transport.TagsMatching;
import ru.concel.routing.astar.transport.TransportType;

public class Automotive
extends TransportType {
    private transient TagsMatching matching;
    private long id = 2L;
    private String name = "\u0410\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u044c";
    private String subName = "";
    private double maxspeed = 150.0;
    private double regularSpeed = 90.0;
    private int linksCountForEndPoints = 1;

    public Automotive(TagsMatching matching) {
        this.matching = matching;
        this.setSubName(matching.getName());
    }

    public Automotive() {
        this.matching = null;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    protected void setTypeName(String name) {
        this.name = name;
    }

    @Override
    public String getSubName() {
        return this.subName;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    @Override
    public double getMaxSpeed() {
        return this.maxspeed;
    }

    public void setMaxSpeed(double maxspeed) {
        this.maxspeed = maxspeed;
    }

    @Override
    public double getRegularSpeed() {
        return this.regularSpeed;
    }

    public void setRegularSpeed(double regularSpeed) {
        this.regularSpeed = regularSpeed;
    }

    @Override
    public TravelTime getTravelTime(Node current, LinkParameters parameters, double start) {
        double time = 0.0;
        if (this.matching != null) {
            TagsMatching.TestMatchingResult r = this.matching.testTag(parameters.properties, this.getRegularSpeed());
            double speed = r.speed.get();
            speed = speed > this.getMaxSpeed() ? this.getMaxSpeed() : speed;
            time = parameters.weight / 1000.0 / speed + r.time.get();
        } else {
            time = parameters.weight / 1000.0 / this.getRegularSpeed();
        }
        TravelTime ret = new TravelTime(this.getTypeName(), this.getSubName(), time + start, time + start, 0.0);
        return ret;
    }

    public void setLinksCountForEndPoints(int linksCountForEndPoints) {
        this.linksCountForEndPoints = linksCountForEndPoints;
    }

    @Override
    public int getLinksCountForEndPoints() {
        return this.linksCountForEndPoints;
    }
}

