/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.transport;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.fitness.TravelTime;
import ru.concel.routing.astar.transport.LinkParameters;
import ru.concel.routing.astar.transport.TransportType;

public class Bus
extends TransportType {
    private long id = 0L;
    private String name = "\u0410\u0432\u0442\u043e\u0431\u0443\u0441";
    private String subName = "";

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    @Override
    public String getSubName() {
        return this.subName;
    }

    @Override
    public double getMaxSpeed() {
        return 120.0;
    }

    @Override
    public double getRegularSpeed() {
        return 80.0;
    }

    @Override
    public TravelTime getTravelTime(Node current, LinkParameters parameters, double start) {
        String routeName = parameters.properties.get("infor_route_key");
        TravelTime ret = Bus.calcTravelTimeOnSchedule(current, parameters.to, start, routeName);
        ret.depart = ret.arrival;
        return ret;
    }

    public static TravelTime calcTravelTimeOnSchedule(Node current, Node dest, double start, String routeName) {
        Set<Map.Entry<String, String>> nodeTags = current.getTags().entrySet();
        Optional<TimeData> tmp = nodeTags.stream().filter(s -> ((String)s.getKey()).startsWith("shedule:" + routeName)).map(s -> {
            String[] ss = ((String)s.getValue()).split(":");
            TimeData ret = new TimeData(ss[1], ss[2]);
            return ret;
        }).filter(td -> {
            double newDayHours = Math.round(Math.floor(start)) % 24L;
            double mins = start - (double)Math.round(Math.floor(start));
            return (double)td.time1.longValue() / 3600.0 >= newDayHours + mins;
        }).min((td1, td2) -> td1.time1.compareTo(td2.time1));
        long additionalDay = Math.round(Math.floor(start / 24.0));
        if (!tmp.isPresent()) {
            ++additionalDay;
            tmp = nodeTags.stream().filter(s -> ((String)s.getKey()).startsWith("shedule:" + routeName)).map(s -> {
                String[] ss = ((String)s.getValue()).split(":");
                return new TimeData(ss[1], ss[2]);
            }).min((td1, td2) -> td1.time1.compareTo(td2.time1));
        }
        if (!tmp.isPresent()) {
            return null;
        }
        TravelTime ret = new TravelTime();
        ret.depart = (double)tmp.get().time1.longValue() / 3600.0;
        ret.arrival = (double)(additionalDay * 24L) + (double)Long.parseLong(tmp.get().time2) / 3600.0;
        return ret;
    }

    @Override
    public int getLinksCountForEndPoints() {
        return 1;
    }

    private static class TimeData {
        public Long time1;
        public String time2;

        public TimeData(String t1, String t2) {
            this.time1 = Long.parseLong(t1);
            this.time2 = t2;
        }
    }
}

