/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.transport;

import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.fitness.TravelTime;
import ru.concel.routing.astar.transport.Bus;
import ru.concel.routing.astar.transport.LinkParameters;
import ru.concel.routing.astar.transport.TransportType;

public class Pedestrian
extends TransportType {
    private long id = 1L;
    private String name = "\u041f\u0435\u0448\u043a\u043e\u043c";
    private String subName = "";

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    @Override
    public String getSubName() {
        return this.subName;
    }

    @Override
    public double getMaxSpeed() {
        return 8.0;
    }

    @Override
    public double getRegularSpeed() {
        return 5.0;
    }

    @Override
    public TravelTime getTravelTime(Node current, LinkParameters parameters, double start) {
        TravelTime p;
        double time = parameters.weight / 1000.0 / this.getRegularSpeed();
        TravelTime ret = new TravelTime(this.name, this.subName, time + start, time + start, 0.01);
        if (parameters.to.isHasTags() && parameters.to.getTags().keySet().contains("bus_stop") && (p = Bus.calcTravelTimeOnSchedule(parameters.to, null, ret.depart, "")) != null) {
            ret.depart = p.depart;
        }
        return ret;
    }

    @Override
    public int getLinksCountForEndPoints() {
        return 8;
    }
}

