/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class TagsMatching {
    private String name;
    private ArrayList<Matching> matchingList = new ArrayList();

    public String getName() {
        return this.name;
    }

    public ArrayList<Matching> getMatchingList() {
        return this.matchingList;
    }

    public TagsMatching(String name) {
        this.name = name;
    }

    public void addMatching(Matching matching) {
        this.matchingList.add(matching);
    }

    public TestMatchingResult testTag(Map<String, String> properties, double speed) {
        ArrayList<Match> mm = new ArrayList<Match>();
        block12: for (Map.Entry<String, String> p : properties.entrySet()) {
            for (Matching m : this.matchingList) {
                if (!m.tagKey.equals(p.getKey()) || m.tagValue != null && !m.tagValue.equals("") && !p.getValue().equals(m.tagValue)) continue;
                mm.add(new Match(m, p.getValue()));
                continue block12;
            }
        }
        Collections.sort(mm);
        TestMatchingResult res = new TestMatchingResult();
        res.speed = Optional.of(speed);
        res.time = Optional.of(0.0);
        for (Match m : mm) {
            if (m.matching.speedPriority) {
                if (m.matching.absolute) {
                    try {
                        res.speed = Optional.of(Double.parseDouble(m.val));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    switch (m.matching.speedOp) {
                        case "*": {
                            res.speed = Optional.of(res.speed.get() * m.matching.speed);
                            break;
                        }
                        case "+": {
                            res.speed = Optional.of(res.speed.get() + Double.parseDouble(m.val));
                            break;
                        }
                        default: {
                            res.speed = Optional.of(res.speed.get() + Double.parseDouble(m.val));
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            res.time = Optional.of(res.time.get() + m.matching.delay);
        }
        return res;
    }

    public TestMatchingResult testTag(String key, String value, double speed) {
        TestMatchingResult res = new TestMatchingResult();
        res.speed = Optional.of(speed);
        res.time = Optional.of(0.0);
        this.matchingList.stream().filter(m -> ((Matching)m).tagKey.equals(key) && (((Matching)m).tagValue == null || ((Matching)m).tagValue.equals("") || value.equals(((Matching)m).tagValue))).forEach(m -> {
            if (((Matching)m).speedPriority) {
                if (((Matching)m).absolute) {
                    try {
                        testMatchingResult.speed = Optional.of(Double.parseDouble(value));
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        switch (((Matching)m).speedOp) {
                            case "*": {
                                testMatchingResult.speed = Optional.of(testMatchingResult.speed.get() * ((Matching)m).speed);
                                break;
                            }
                            case "+": {
                                testMatchingResult.speed = Optional.of(testMatchingResult.speed.get() + Double.parseDouble(value));
                                break;
                            }
                            default: {
                                testMatchingResult.speed = Optional.of(testMatchingResult.speed.get() + Double.parseDouble(value));
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                testMatchingResult.time = Optional.of(testMatchingResult.time.get() + ((Matching)m).delay);
            }
        });
        return res;
    }

    private static class Match
    implements Comparable<Match> {
        public Matching matching;
        public String val;

        public Match(Matching matching, String val) {
            this.matching = matching;
            this.val = val;
        }

        @Override
        public int compareTo(Match o) {
            int r1 = Boolean.compare(o.matching.speedPriority, this.matching.speedPriority);
            if (r1 == 0) {
                r1 = Boolean.compare(o.matching.absolute, this.matching.absolute);
            }
            return r1;
        }
    }

    public static class Matching {
        private String tagKey;
        private String tagValue;
        private boolean speedPriority;
        private boolean absolute;
        private double speed;
        private String speedOp;
        private double delay;

        public String getTagKey() {
            return this.tagKey;
        }

        public void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public String getTagValue() {
            return this.tagValue;
        }

        public void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        public boolean isSpeedPriority() {
            return this.speedPriority;
        }

        public void setSpeedPriority(boolean speedPriority) {
            this.speedPriority = speedPriority;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public void setAbsolute(boolean absolute) {
            this.absolute = absolute;
        }

        public double getSpeed() {
            return this.speed;
        }

        public void setSpeed(double speed) {
            this.speed = speed;
        }

        public String getSpeedOp() {
            return this.speedOp;
        }

        public void setSpeedOp(String speedOp) {
            this.speedOp = speedOp;
        }

        public double getDelay() {
            return this.delay;
        }

        public void setDelay(double delay) {
            this.delay = delay;
        }

        public Matching(String tagKey, String tagValue, boolean speedPriority, boolean absolute, double speed, String speedOp, double delay) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.speedPriority = speedPriority;
            this.absolute = absolute;
            this.speed = speed;
            this.speedOp = speedOp;
            this.delay = delay;
        }
    }

    public static class TestMatchingResult {
        public Optional<Double> speed;
        public Optional<Double> time;
    }
}

