/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.fitness.TravelTime;
import ru.concel.routing.astar.transport.Automotive;
import ru.concel.routing.astar.transport.Bus;
import ru.concel.routing.astar.transport.LinkParameters;
import ru.concel.routing.astar.transport.Pedestrian;
import ru.concel.routing.astar.transport.TagsMatching;

public abstract class TransportType {
    private static final Logger logger = Logger.getLogger(TransportType.class);
    private static List<TransportType> registered = new ArrayList<TransportType>();

    public abstract long getID();

    public abstract String getTypeName();

    public abstract String getSubName();

    public abstract double getMaxSpeed();

    public abstract double getRegularSpeed();

    public abstract TravelTime getTravelTime(Node var1, LinkParameters var2, double var3);

    public abstract int getLinksCountForEndPoints();

    public static Stream<TransportType> getRegisteredTypes() {
        if (registered.size() == 0) {
            TransportType.getDefaultTypes().forEach(registered::add);
        }
        return registered.stream();
    }

    public static Stream<TransportType> getDefaultTypes() {
        TagsMatching tm1 = new TagsMatching("\u041b\u0435\u0433\u043a\u043e\u0432\u043e\u0439");
        tm1.addMatching(new TagsMatching.Matching("bus_stop", "path", true, false, 1.0E-9, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("infor_route_key", null, true, false, 1.0E-9, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("maxspeed", null, true, true, 0.0, "", 0.0));
        tm1.addMatching(new TagsMatching.Matching("forbidden_for_oneway", "yes", true, false, 1.0E-4, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "cycleway", true, false, 0.01, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "footway", true, false, 0.01, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "steps", true, false, 1.0E-6, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "service", true, false, 0.5, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "pedestrian", true, false, 0.01, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "primary", true, false, 1.5, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "trunk", true, false, 2.0, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "secondary", true, false, 1.2, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "residential", true, false, 0.7, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "track", true, false, 0.2, "*", 0.0));
        tm1.addMatching(new TagsMatching.Matching("highway", "path", true, false, 0.01, "*", 0.0));
        return Stream.of(new Bus(), new Pedestrian(), new Automotive(tm1));
    }

    public static long addType(String name, String subname, List<TagsMatching.Matching> m, double maxspeed, double regularSpeed, int linksCountForEndPoints) {
        TagsMatching tm = new TagsMatching(subname);
        m.forEach(tm::addMatching);
        Automotive t = new Automotive(tm);
        t.setTypeName(name);
        t.setSubName(subname);
        long id = registered.stream().map(TransportType::getID).max((a, b) -> Long.compare(a, b)).orElse(-1L) + 1L;
        logger.debug((Object)("name=" + name + " id=" + id));
        t.setID(id);
        t.setMaxSpeed(maxspeed);
        t.setRegularSpeed(regularSpeed);
        t.setLinksCountForEndPoints(linksCountForEndPoints);
        registered.add(t);
        return id;
    }

    public static void updateType(long id, String name, String subname, List<TagsMatching.Matching> m, double maxspeed, double regularSpeed, int linksCountForEndPoints) {
        logger.debug((Object)("Update transport type " + name + (subname == null ? "" : ":" + subname) + " with " + m.size() + " matching rules. id=" + id + ", maxspeed=" + maxspeed + ", regularspeed=" + regularSpeed + ", linksCountForEndPoints=" + linksCountForEndPoints));
        Iterator<TransportType> i = registered.iterator();
        while (i.hasNext()) {
            TransportType tt = i.next();
            if (tt.getID() != id) continue;
            i.remove();
        }
        TagsMatching tm = new TagsMatching(subname);
        m.forEach(tm::addMatching);
        Automotive t = new Automotive(tm);
        t.setTypeName(name);
        t.setID(id);
        t.setMaxSpeed(maxspeed);
        t.setRegularSpeed(regularSpeed);
        t.setLinksCountForEndPoints(linksCountForEndPoints);
        logger.debug((Object)("Push rules to type with " + tm.getMatchingList().size() + " matching rules"));
        registered.add(t);
    }
}

