/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import ru.concel.routing.astar.Link;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.NodeFactoryIsNotInstalled;
import ru.concel.routing.astar.transport.Pedestrian;
import ru.concel.routing.map.LinkMode;
import ru.concel.routing.map.RouteFromStartToLink;
import ru.concel.routing.map.SetNodesWithLinks;

public class RoutingMap {
    private static Logger logger = Logger.getLogger(RoutingMap.class);
    private TLongObjectHashMap<Node> map = new TLongObjectHashMap();
    private STRtree linkIndex = new STRtree(2000);
    private Set<Node> stops = new HashSet<Node>();
    private Quadtree barrierIndex = new Quadtree();
    private static long fakeid = 35000000000L;
    private static CoordinateReferenceSystem flat;
    private static MathTransform wgs84_to_flat;
    private static MathTransform flat_to_wgs84;
    private static GeometryFactory wgs84gf;

    public void putBarrier(Coordinate[] geometry, boolean area) {
        Object barrier = area ? new Polygon(new LinearRing((CoordinateSequence)new CoordinateArraySequence(geometry), wgs84gf), null, wgs84gf) : new LineString((CoordinateSequence)new CoordinateArraySequence(geometry), wgs84gf);
        this.barrierIndex.insert(barrier.getEnvelopeInternal(), barrier);
    }

    public boolean isObstacle(Coordinate point, double precision) {
        return false;
    }

    private List<IndexItem> query(double expand, Envelope e, int count) {
        count = count >= 5 ? count : 5;
        e.expandBy(expand);
        List r = this.linkIndex.query(e);
        if (r.size() > count || expand > 100000.0) {
            return r;
        }
        return this.query(expand * 10.0, e, count);
    }

    public List<RouteFromStartToLink> createLinkFromPointToMap(double lat, double lon, LinkMode mode, int count, Map<String, String> linkParameters) throws NodeFactoryIsNotInstalled {
        Node pstart = Node.getFactory().get().createNode(fakeid++);
        pstart.setLat(lat);
        pstart.setLon(lon);
        logger.debug((Object)("Map index size is " + this.linkIndex.size()));
        return this.createLinkFromPointToRoad(mode, pstart, count, linkParameters);
    }

    public List<RouteFromStartToLink> createLinkFromPointToRoad(LinkMode mode, Node start, int count, Map<String, String> linkParameters) {
        ArrayList<RouteFromStartToLink> ret = new ArrayList<RouteFromStartToLink>(count);
        try {
            Coordinate c = new Coordinate(start.getLon(), start.getLat());
            Geometry pt = JTS.transform((Geometry)new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{c}), wgs84gf), (MathTransform)wgs84_to_flat);
            Envelope e = new Envelope(pt.getCoordinate());
            List<IndexItem> lines = this.query(1.0, e, count);
            logger.debug((Object)("Query index result is " + lines.size() + " lines"));
            lines.stream().sorted((l1, l2) -> {
                l1.fitness = this.calcNearestPointFromNodeToLink(pt, (IndexItem)l1);
                l2.fitness = this.calcNearestPointFromNodeToLink(pt, (IndexItem)l2);
                return l1.fitness.max.compareTo(l2.fitness.max);
            }).limit(count).forEach(cr -> {
                try {
                    RouteFromStartToLink rsl = new RouteFromStartToLink();
                    Node pperp = Node.getFactory().get().createNode(fakeid++);
                    Point crpt = (Point)JTS.transform((Geometry)new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(cr.fitness.p.x, cr.fitness.p.y)}), wgs84gf), (MathTransform)flat_to_wgs84);
                    pperp.setLat(crpt.getY());
                    pperp.setLon(crpt.getX());
                    rsl.fakePoints.add(start.getId());
                    rsl.fakePoints.add(pperp.getId());
                    GeodeticCalculator gc = new GeodeticCalculator();
                    switch (mode) {
                        case FROM: {
                            logger.debug((Object)"Calculate FROM links");
                            Link l = new Link(pperp);
                            gc.setStartingGeographicPoint(start.getLon(), start.getLat());
                            gc.setDestinationGeographicPoint(l.getTo().getLon(), l.getTo().getLat());
                            l.setWeight(gc.getOrthodromicDistance() * 1.0E-5);
                            for (Map.Entry entry : linkParameters.entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            start.addLink(l);
                            logger.debug((Object)("Add temporary link from " + start.getId() + " to " + l.getTo().getId() + " with weight " + l.getWeight()));
                            Link l1 = new Link(cr.n0);
                            gc.setStartingGeographicPoint(pperp.getLon(), pperp.getLat());
                            gc.setDestinationGeographicPoint(l1.getTo().getLon(), l1.getTo().getLat());
                            l1.setWeight(gc.getOrthodromicDistance());
                            for (Map.Entry<Object, Object> entry : linkParameters.entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            Link l2 = new Link(cr.link.getTo());
                            gc.setStartingGeographicPoint(pperp.getLon(), pperp.getLat());
                            gc.setDestinationGeographicPoint(l2.getTo().getLon(), l2.getTo().getLat());
                            l2.setWeight(gc.getOrthodromicDistance());
                            for (Map.Entry<Object, Object> entry : linkParameters.entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            pperp.addLink(l1);
                            logger.debug((Object)("Add temporary link from " + pperp.getId() + " to " + l1.getTo().getId() + " with weight " + l1.getWeight()));
                            pperp.addLink(l2);
                            logger.debug((Object)("Add temporary link from " + pperp.getId() + " to " + l2.getTo().getId() + " with weight " + l2.getWeight()));
                            break;
                        }
                        case TO: {
                            logger.debug((Object)"Calculate TO links");
                            Link l = new Link(start);
                            gc.setStartingGeographicPoint(pperp.getLon(), pperp.getLat());
                            gc.setDestinationGeographicPoint(l.getTo().getLon(), l.getTo().getLat());
                            l.setWeight(gc.getOrthodromicDistance() * 1.0E-5);
                            for (Map.Entry entry : linkParameters.entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            logger.debug((Object)("Add temporary link from " + pperp.getId() + " to " + l.getTo().getId() + " with weight " + l.getWeight()));
                            pperp.addLink(l);
                            Link l1 = new Link(pperp);
                            gc.setStartingGeographicPoint(cr.n0.getLon(), cr.n0.getLat());
                            gc.setDestinationGeographicPoint(l1.getTo().getLon(), l1.getTo().getLat());
                            l1.setWeight(gc.getOrthodromicDistance());
                            for (Map.Entry<Object, Object> entry : linkParameters.entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            Link l2 = new Link(pperp);
                            gc.setStartingGeographicPoint(cr.link.getTo().getLon(), cr.link.getTo().getLat());
                            gc.setDestinationGeographicPoint(l2.getTo().getLon(), l2.getTo().getLat());
                            l2.setWeight(gc.getOrthodromicDistance());
                            for (Map.Entry<Object, Object> entry : linkParameters.entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            logger.debug((Object)("Add temporary link from " + cr.n0.getId() + " to " + l1.getTo().getId() + " with weight " + l1.getWeight()));
                            cr.n0.addLink(l1);
                            logger.debug((Object)("Add temporary link from " + cr.link.getTo().getId() + " to " + l2.getTo().getId() + " with weight " + l2.getWeight()));
                            cr.link.getTo().addLink(l2);
                            rsl.links = new ArrayList<RouteFromStartToLink.LinkForRemove>(2);
                            rsl.links.add(new RouteFromStartToLink.LinkForRemove(cr.n0, l1));
                            rsl.links.add(new RouteFromStartToLink.LinkForRemove(cr.link.getTo(), l2));
                            break;
                        }
                        case BOTH: {
                            Link l = new Link(pperp);
                            gc.setStartingGeographicPoint(start.getLon(), start.getLat());
                            gc.setDestinationGeographicPoint(l.getTo().getLon(), l.getTo().getLat());
                            l.setWeight(gc.getOrthodromicDistance() * 1.0E-5);
                            for (Map.Entry entry : linkParameters.entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            start.addLink(l);
                            l = new Link(start);
                            l.setWeight(gc.getOrthodromicDistance() * 1.0E-5);
                            for (Map.Entry<Object, Object> entry : linkParameters.entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            pperp.addLink(l);
                            Link l1 = new Link(cr.n0);
                            gc.setStartingGeographicPoint(pperp.getLon(), pperp.getLat());
                            gc.setDestinationGeographicPoint(l1.getTo().getLon(), l1.getTo().getLat());
                            double dist1 = gc.getOrthodromicDistance();
                            l1.setWeight(dist1);
                            for (Map.Entry entry : linkParameters.entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            Link l2 = new Link(cr.link.getTo());
                            gc.setStartingGeographicPoint(pperp.getLon(), pperp.getLat());
                            gc.setDestinationGeographicPoint(l2.getTo().getLon(), l2.getTo().getLat());
                            double dist2 = gc.getOrthodromicDistance();
                            l2.setWeight(dist2);
                            for (Map.Entry entry : linkParameters.entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            pperp.addLink(l1);
                            pperp.addLink(l2);
                            l1 = new Link(pperp);
                            l1.setWeight(dist1);
                            for (Map.Entry<Object, Object> entry : linkParameters.entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l1.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            l2 = new Link(pperp);
                            l2.setWeight(dist2);
                            for (Map.Entry<Object, Object> entry : linkParameters.entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            for (Map.Entry<Object, Object> entry : cr.link.getTags().entrySet()) {
                                l2.addTag((String)entry.getKey(), (String)entry.getValue());
                            }
                            cr.n0.addLink(l1);
                            cr.link.getTo().addLink(l2);
                            rsl.links = new ArrayList<RouteFromStartToLink.LinkForRemove>(2);
                            rsl.links.add(new RouteFromStartToLink.LinkForRemove(cr.n0, l1));
                            rsl.links.add(new RouteFromStartToLink.LinkForRemove(cr.link.getTo(), l2));
                            break;
                        }
                    }
                    this.map.put(start.getId(), (Object)start);
                    this.map.put(pperp.getId(), (Object)pperp);
                    rsl.id = start.getId();
                    ret.add(rsl);
                }
                catch (TransformException | NodeFactoryIsNotInstalled te) {
                    logger.error((Object)"Can't create link from point to roads", te);
                }
            });
        }
        catch (MismatchedDimensionException | TransformException e1) {
            e1.printStackTrace();
        }
        return ret;
    }

    private CurrentResult calcNearestPointFromNodeToLink(Geometry pt, IndexItem l) {
        CurrentResult ret = new CurrentResult();
        try {
            Coordinate point;
            LineString g = new LineString((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(l.n0.getLon(), l.n0.getLat()), new Coordinate(l.link.getTo().getLon(), l.link.getTo().getLat())}), wgs84gf);
            LocationIndexedLine g1 = new LocationIndexedLine(JTS.transform((Geometry)g, (MathTransform)wgs84_to_flat));
            LinearLocation here = g1.project(pt.getCoordinate());
            ret.p = point = g1.extractPoint(here);
            double dist = point.distance(pt.getCoordinate());
            ret.max = dist;
        }
        catch (TransformException e2) {
            e2.printStackTrace();
            ret.max = Double.MAX_VALUE;
        }
        return ret;
    }

    public void createIndex() {
        this.map.forEachValue(n -> {
            if (n.isLinksNeedForIndex()) {
                n.getLinks().stream().forEach(l -> {
                    try {
                        if (n.isReady() && l.getTo().isReady()) {
                            LineString g = new LineString((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(n.getLon(), n.getLat()), new Coordinate(l.getTo().getLon(), l.getTo().getLat())}), wgs84gf);
                            Geometry g1 = JTS.transform((Geometry)g, (MathTransform)wgs84_to_flat);
                            IndexItem ii = new IndexItem();
                            ii.n0 = n;
                            ii.link = l;
                            this.linkIndex.insert(g1.getEnvelopeInternal(), (Object)ii);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            return true;
        });
        this.stops.stream().forEach(s -> this.createLinkFromPointToRoad(LinkMode.BOTH, (Node)s, new Pedestrian().getLinksCountForEndPoints(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("bus_stop", "path");
            }
        }));
        logger.debug((Object)("Spatial index created, size is " + this.linkIndex.size()));
    }

    public Node get(long id) {
        return (Node)this.map.get(id);
    }

    public SetNodesWithLinks getByLinkTag(final String matchKey, final String matchVal) {
        final SetNodesWithLinks ret = new SetNodesWithLinks();
        ret.nodes = new HashSet<Node>();
        this.map.forEachValue((TObjectProcedure)new TObjectProcedure<Node>(){

            public boolean execute(Node n) {
                n.getLinks().stream().filter(l -> l.getTags().entrySet().stream().anyMatch(e -> e.getKey() != null && e.getValue() != null && ((String)e.getKey()).contains(matchKey) && (matchVal == null || matchVal != null && ((String)e.getValue()).contains(matchVal)))).forEach(l -> {
                    setNodesWithLinks.nodes.add(n);
                    setNodesWithLinks.nodes.add(l.getTo());
                });
                return true;
            }
        });
        return ret;
    }

    public void addTagToNode(Node n, String key, String val) {
        if (n != null) {
            n.addTag(key, val);
            if ("bus_stop".equals(key.trim().toLowerCase())) {
                this.stops.add(n);
            }
        }
    }

    public void cleanTempPoints(List<RouteFromStartToLink> listOfRSL) {
        listOfRSL.stream().forEach(rsl -> {
            if (rsl.fakePoints != null) {
                rsl.fakePoints.forEach(p -> {
                    Node point = (Node)this.map.get(p.longValue());
                    if (point != null) {
                        point.getLinks().forEach(l -> l.setTo(null));
                        this.map.remove(p.longValue());
                    }
                });
            }
            if (rsl.links != null) {
                rsl.links.forEach(l -> l.clean());
            }
        });
    }

    public int mapSize() {
        return this.map.size();
    }

    public void sheduleUpdate() {
        this.map.forEachValue((TObjectProcedure)new TObjectProcedure<Node>(){

            public boolean execute(Node n) {
                ArrayList sh1 = new ArrayList();
                ArrayList sh2 = new ArrayList();
                n.getTags().entrySet().stream().forEach(ekv -> {
                    String k = (String)ekv.getKey();
                    String v = (String)ekv.getValue();
                    if (k.startsWith("time:")) {
                        String route = k.split(":")[1];
                        Long shift = Long.parseLong(v);
                        n.getLinks().stream().filter(l -> route.equals(l.getTags().get("infor_route_key"))).forEach(l2 -> l2.getTags().entrySet().stream().filter(ek1v1 -> ((String)ek1v1.getKey()).startsWith("start:")).map(e -> (String)e.getValue()).forEach(v1 -> {
                            String[] time = v1.split(":");
                            sh1.add(route + ":" + (Long.parseLong(time[0]) * 3600L + Long.parseLong(time[1]) * 60L + shift));
                            Node to = l2.getTo();
                            if (to != null) {
                                long shift1 = Long.parseLong(to.getTags().get("time:" + route));
                                sh2.add(Long.parseLong(time[0]) * 3600L + Long.parseLong(time[1]) * 60L + shift1);
                            }
                        }));
                    }
                });
                for (int i = 0; i < sh1.size(); ++i) {
                    n.addTag("shedule:" + (String)sh1.get(i), (String)sh1.get(i) + ":" + sh2.get(i));
                }
                return true;
            }
        });
    }

    public void updateLinkWeights() {
        final GeodeticCalculator gc = new GeodeticCalculator();
        this.map.forEachValue((TObjectProcedure)new TObjectProcedure<Node>(){

            public boolean execute(Node n) {
                gc.setStartingGeographicPoint(n.getLon(), n.getLat());
                for (Link l : n.getLinks()) {
                    gc.setDestinationGeographicPoint(l.getTo().getLon(), l.getTo().getLat());
                    l.setWeight(gc.getOrthodromicDistance());
                }
                return true;
            }
        });
    }

    public void put(Long id, Node n) {
        this.map.put(id.longValue(), (Object)n);
    }

    static {
        try {
            flat = CRS.decode((String)"EPSG:3857");
            wgs84_to_flat = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)flat);
            flat_to_wgs84 = CRS.findMathTransform((CoordinateReferenceSystem)flat, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            wgs84gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class CurrentResult {
        public Double max;
        public Coordinate p;

        private CurrentResult() {
        }
    }

    private static class IndexItem {
        public Node n0;
        public Link link;
        public CurrentResult fitness;

        private IndexItem() {
        }
    }
}

