/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.spatialdata;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.concel.routing.astar.Node;
import ru.concel.routing.map.RoutingMap;
import ru.concel.routing.spatialdata.State;

public class OSMNodeHandler
extends DefaultHandler {
    private RoutingMap roadNetwork;
    private int nodes = 0;
    private State state;
    private Node n;
    private static Logger logger = Logger.getLogger(OSMNodeHandler.class);

    public OSMNodeHandler(RoutingMap roadNetwork) {
        this.roadNetwork = roadNetwork;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("node".equals(localName.toLowerCase())) {
            this.n = this.roadNetwork.get(Long.parseLong(attributes.getValue("id")));
            if (this.n != null) {
                this.state = State.NODE;
                ++this.nodes;
                if (this.nodes % 100000 == 0) {
                    logger.debug((Object)("Read " + this.nodes + " nodes"));
                }
                this.n.setLat(Double.parseDouble(attributes.getValue("lat")));
                this.n.setLon(Double.parseDouble(attributes.getValue("lon")));
                this.n.setReady(true);
            }
        } else if (this.state == State.NODE && "tag".equals(localName.toLowerCase())) {
            this.roadNetwork.addTagToNode(this.n, attributes.getValue("k"), attributes.getValue("v"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("node".equals(localName.toLowerCase())) {
            this.state = State.NOTHING;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = State.NOTHING;
    }
}

