/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.spatialdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.concel.routing.astar.Link;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.NodeFactoryIsNotInstalled;
import ru.concel.routing.map.RoutingMap;
import ru.concel.routing.spatialdata.State;

public class OSMWayHandler
extends DefaultHandler {
    private State state;
    private boolean oneway = false;
    private boolean index = true;
    private static Logger logger = Logger.getLogger(OSMWayHandler.class);
    private RoutingMap roadNetwork;
    private int roads = 0;
    private ArrayList<Long> points = new ArrayList();
    private Set<Long> wp = new HashSet<Long>();
    private HashMap<String, String> tags = new HashMap();
    private boolean reverse = false;

    public OSMWayHandler(RoutingMap roadNetwork) {
        this.roadNetwork = roadNetwork;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("way".equals(localName.toLowerCase())) {
            if (this.state == State.ROAD) {
                Node prev = null;
                ++this.roads;
                if (this.roads % 10000 == 0) {
                    logger.debug((Object)("Read " + this.roads + " roads"));
                }
                for (Long id : this.points) {
                    Node n = this.roadNetwork.get(id);
                    if (n == null) {
                        try {
                            n = Node.getFactory().get().createNode(id);
                            this.roadNetwork.put(id, n);
                        }
                        catch (NodeFactoryIsNotInstalled e) {
                            throw new SAXException("Can't create node. Node factory is not installed");
                        }
                    }
                    n.setLinksNeedForIndex(n.isLinksNeedForIndex() & this.index);
                    if (prev != null) {
                        Link l1 = new Link(n);
                        for (Map.Entry<String, String> e : this.tags.entrySet()) {
                            l1.addTag(e.getKey(), e.getValue());
                        }
                        prev.addLink(l1);
                        Link l2 = new Link(prev);
                        for (Map.Entry<String, String> e : this.tags.entrySet()) {
                            l2.addTag(e.getKey(), e.getValue());
                        }
                        n.addLink(l2);
                        if (this.oneway) {
                            if (this.reverse) {
                                l1.addTag("forbidden_for_oneway", "yes");
                            } else {
                                l2.addTag("forbidden_for_oneway", "yes");
                            }
                        }
                    }
                    prev = n;
                }
                this.wp.addAll(this.points);
            }
            this.state = State.NOTHING;
            this.points.clear();
            this.oneway = false;
            this.index = true;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = State.BEGIN;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("way".equals(localName.toLowerCase())) {
            this.state = State.WAY;
            this.tags.clear();
            this.reverse = false;
        }
        if ((this.state == State.WAY || this.state == State.ROAD) && "nd".equals(localName.toLowerCase())) {
            this.points.add(Long.parseLong(attributes.getValue("ref")));
        }
        if ((this.state == State.WAY || this.state == State.ROAD) && "tag".equals(localName.toLowerCase())) {
            this.tags.put(attributes.getValue("k"), attributes.getValue("v"));
            if ("highway".equals(attributes.getValue("k")) || "infor_route_key".equals(attributes.getValue("k"))) {
                this.state = State.ROAD;
                if ("infor_route_key".equals(attributes.getValue("k"))) {
                    this.oneway = true;
                    this.index = false;
                }
            } else if ("oneway".equals(attributes.getValue("k")) && ("yes".equals(attributes.getValue("v")) || "1".equals(attributes.getValue("v")))) {
                this.oneway = true;
            } else if ("oneway".equals(attributes.getValue("k")) && "-1".equals(attributes.getValue("v"))) {
                this.oneway = true;
                this.reverse = true;
            }
        }
    }
}

