/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.spatialdata;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.geotools.referencing.GeodeticCalculator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ru.concel.routing.astar.Link;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.NodeFactory;
import ru.concel.routing.astar.NodeHeap;
import ru.concel.routing.map.RoutingMap;
import ru.concel.routing.spatialdata.OSMNodeHandler;
import ru.concel.routing.spatialdata.OSMWayHandler;

public class SpatialDataReader {
    private static Logger logger = Logger.getLogger(SpatialDataReader.class);
    private static HashMap<String, Routes> routes;
    private static HashMap<String, Node> stopNodeList;
    private static Random random;
    private static Set<String> allowRoutes;

    public static RoutingMap getMap(String path) throws Exception {
        RoutingMap rn = new RoutingMap();
        File f = new File(path);
        if (f.isFile()) {
            SpatialDataReader.run(rn, f);
        } else if (f.isDirectory()) {
            Arrays.stream(f.listFiles()).filter(f1 -> !f1.getName().endsWith("~")).forEach(f1 -> {
                try {
                    SpatialDataReader.run(rn, f1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        SpatialDataReader.updateCSVRoutes(rn);
        rn.updateLinkWeights();
        rn.sheduleUpdate();
        rn.createIndex();
        return rn;
    }

    private static void run(RoutingMap rn, File f) throws Exception {
        String lc = f.getAbsolutePath().toLowerCase();
        if (lc.endsWith(".xml") || lc.endsWith(".osm")) {
            SpatialDataReader.runXML(rn, f);
        } else if (lc.endsWith(".csv")) {
            SpatialDataReader.runCSV(rn, f);
        }
    }

    private static void runCSV(RoutingMap rn, File f) throws IOException, SAXException {
        logger.debug((Object)("CSV processing: " + f.getAbsolutePath()));
        Optional<HashMap> names = Files.lines(f.toPath(), Charset.forName("windows-1251")).limit(1L).map(s -> s.split(";")).map(s -> {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            for (int i = 0; i < ((String[])s).length; ++i) {
                m.put(s[i], i);
            }
            return m;
        }).findFirst();
        if (names.isPresent()) {
            Stream<String[]> lines = Files.lines(f.toPath(), Charset.forName("windows-1251")).skip(1L).map(s -> s.split(";"));
            if (names.get().containsKey("stop_id")) {
                lines.forEach(s -> {
                    try {
                        Node node = stopNodeList.getOrDefault(s[(Integer)((HashMap)names.get()).get("description")], Node.getFactory().get().createAutoNode());
                        node.setLat(Double.parseDouble(s[(Integer)((HashMap)names.get()).get("lat")]));
                        node.setLon(Double.parseDouble(s[(Integer)((HashMap)names.get()).get("lon")]));
                        Long time = Long.parseLong(s[(Integer)((HashMap)names.get()).get("time")]);
                        node.addTag("time%raw:" + s[(Integer)((HashMap)names.get()).get("route_id")] + "_" + s[(Integer)((HashMap)names.get()).get("direction")], time + "");
                        rn.addTagToNode(node, "bus_stop", s[(Integer)((HashMap)names.get()).get("description")]);
                        stopNodeList.putIfAbsent(s[(Integer)((HashMap)names.get()).get("description")], node);
                        Routes r = routes.getOrDefault(s[(Integer)((HashMap)names.get()).get("route_id")] + "_" + s[(Integer)((HashMap)names.get()).get("direction")], new Routes());
                        r.id = s[(Integer)((HashMap)names.get()).get("route_id")];
                        r.stops.put(Integer.parseInt(s[(Integer)((HashMap)names.get()).get("num")]), node);
                        routes.putIfAbsent(s[(Integer)((HashMap)names.get()).get("route_id")] + "_" + s[(Integer)((HashMap)names.get()).get("direction")], r);
                        node.setLinksNeedForIndex(false);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Node factory is not installed");
                    }
                });
            } else if (names.get().containsKey("routegeom")) {
                lines.forEach(s -> {
                    SpatialDataReader.updateRouteName(names, s, "0");
                    SpatialDataReader.updateRouteName(names, s, "1");
                });
            } else if (names.get().containsKey("_runat")) {
                lines.forEach(s -> {
                    for (int direction = 0; direction < 2; ++direction) {
                        Routes r = routes.getOrDefault(s[(Integer)((HashMap)names.get()).get("route_id")] + "_" + direction, new Routes());
                        r.schedule.add(s[(Integer)((HashMap)names.get()).get("_runat")]);
                        routes.putIfAbsent(s[(Integer)((HashMap)names.get()).get("route_id")] + "_" + direction, r);
                    }
                });
            }
        }
    }

    private static void updateCSVRoutes(RoutingMap rn) {
        GeodeticCalculator gc = new GeodeticCalculator();
        routes.values().stream().filter(r -> r.name != null).forEach(r -> {
            r.stops.entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).map(e -> (Node)e.getValue()).findFirst().ifPresent(n -> {
                rn.addTagToNode((Node)n, "time:" + routes.name, "0");
                rn.put(n.getId(), (Node)n);
                rn.addTagToNode((Node)n, "total%time:" + routes.name, "0.0");
                rn.put(n.getId(), (Node)n);
            });
            HashMap<String, String> addedTags = new HashMap<String, String>();
            addedTags.put("infor_route_key", r.name);
            if (r.schedule != null && r.schedule.size() > 0) {
                r.schedule.stream().sorted((s1, s2) -> {
                    String[] t1 = s1.split(":");
                    Long tt1 = 0L;
                    for (int i = t1.length - 1; i >= 0; --i) {
                        tt1 = Math.round((double)Long.parseLong(t1[i]) * Math.pow(60.0, t1.length - i - 1));
                    }
                    String[] t2 = s2.split(":");
                    Long tt2 = 0L;
                    for (int i = t1.length - 1; i >= 0; --i) {
                        tt2 = Math.round((double)Long.parseLong(t2[i]) * Math.pow(60.0, t2.length - i - 1));
                    }
                    return tt1.compareTo(tt2);
                }).reduce("1", (i, s) -> {
                    addedTags.put("start:" + i, (String)s);
                    return "" + (Integer.parseInt(i) + 1);
                });
            } else {
                addedTags.put("schedule", "fake");
                int min = 15;
                for (int i2 = 0; i2 < 24; ++i2) {
                    for (int j = 0; j < 60; j += min % 60) {
                        addedTags.put("start:" + (1 + j / (min % 60) + i2 * (min % 60)), i2 + ":" + (j + random.nextInt(min % 60)));
                    }
                }
            }
            r.stops.entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).map(e -> (Node)e.getValue()).reduce((n1, n2) -> {
                rn.put(n2.getId(), (Node)n2);
                Link to = new Link((Node)n2);
                n1.addLink(to);
                addedTags.forEach((key, val) -> to.addTag((String)key, (String)val));
                if (n2.getTags().containsKey("time%raw:" + routes.id + "_" + routes.name.split("_")[1])) {
                    rn.addTagToNode((Node)n2, "time:" + routes.name, n2.getTags().get("time%raw:" + routes.id + "_" + routes.name.split("_")[1]));
                    rn.addTagToNode((Node)n2, "total%time:" + routes.name, n2.getTags().get("time%raw"));
                } else {
                    gc.setStartingGeographicPoint(n1.getLon(), n1.getLat());
                    gc.setDestinationGeographicPoint(n2.getLon(), n2.getLat());
                    double totalTime = Double.parseDouble(n1.getTags().get("total%time:" + routes.name)) + 60.0 * gc.getOrthodromicDistance() / 1000.0 / 40.0 + 0.5;
                    rn.addTagToNode((Node)n2, "time:" + routes.name, "" + Math.round(totalTime));
                    rn.addTagToNode((Node)n2, "total%time:" + routes.name, "" + totalTime);
                }
                return n2;
            });
        });
    }

    private static void updateRouteName(Optional<HashMap<String, Integer>> names, String[] s, String direction) {
        Routes r = routes.getOrDefault(s[names.get().get("id")] + "_" + direction, new Routes());
        r.name = s[names.get().get("name")] + "_" + direction;
        routes.putIfAbsent(s[names.get().get("id")] + "_" + direction, r);
    }

    private static void runXML(RoutingMap rn, File f) throws IOException, SAXException, ParserConfigurationException {
        logger.debug((Object)("XML processing: " + f.getAbsolutePath()));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(new OSMWayHandler(rn));
        xmlReader.parse(f.getAbsolutePath());
        xmlReader.setContentHandler(new OSMNodeHandler(rn));
        xmlReader.parse(f.getAbsolutePath());
    }

    static {
        if (!Node.isNodeFactoryInstalled()) {
            Node.setFactory(new NodeFactory(NodeHeap::new));
        }
        routes = new HashMap();
        stopNodeList = new HashMap();
        random = new Random();
        allowRoutes = new HashSet<String>();
        allowRoutes.add("290 \u0414\u043e\u043a-\u0422\u0435\u043b\u0435\u0446\u0435\u043d\u0442\u0440");
        allowRoutes.add("15 \u0421\u0435\u0432. \u0410\u0412-\u043f.\u0422\u0438\u043c\u0430\u0448\u0435\u0432\u043e");
        allowRoutes.add("74 \u0414\u043e\u043a-\u0443\u043b.\u0414\u0437\u0435\u0440\u0436\u0438\u043d\u0441\u043a\u043e\u0433\u043e");
        allowRoutes.add("24 \u041b\u0435\u0432\u044b\u0439 \u0431\u0435\u0440\u0435\u0433- \u0428\u043a\u043e\u043b\u0430 128");
        allowRoutes.add("74\u044d \u0414\u043e\u043a-\u0443\u043b.\u0414\u0437\u0435\u0440\u0436\u0438\u043d\u0441\u043a\u043e\u0433\u043e");
        allowRoutes.add("9 \u0421\u0435\u0432.\u0410\u0412- \u043f. \u0422\u0443\u0440\u0431\u0430\u0441\u043b\u044b");
        allowRoutes.add("57 \u0418\u043c\u043c\u0443\u043d\u043e\u043f\u0440\u0435-\u0411\u043e\u043b\u044c\u043d\u0438\u0446\u0430 \u211621");
        allowRoutes.add("16 \u0443\u043b. \u0414\u0430\u0433\u0435\u0441-\u0430\u044f - \u041a\u0440\u0430\u0439\u043d\u044f\u044f");
        allowRoutes.add("3 \u0411\u0435\u043b\u043e\u0440\u0435\u0447\u0435\u043d\u0441\u043a\u0438\u0439-\u0414\u0437\u0435\u0440\u0436\u0438\u043d\u0441\u043a");
        allowRoutes.add("30\u043a \u0421\u0422\u041e - \u0426\u0435\u043d\u0442\u0440. \u0440-\u043a");
        allowRoutes.add("59\u044d \u0428\u0430\u043a\u0448\u0430-2 - \u0411\u0413\u0423");
        allowRoutes.add("54 \u0421\u0438\u043f\u0430\u0439\u043b\u043e\u0432\u043e-\u0418\u043c\u043c\u0443\u043d\u043e\u043f\u0440\u0435\u043f\u0430\u0440");
        allowRoutes.add("35\u043a-\u0423\u041c\u041f\u041e--\u0428\u0430\u043a\u0448\u0430-2");
        allowRoutes.add("27 \u0421\u0438\u043f\u0430\u0439\u043b\u043e\u0432\u043e \u0422\u042d\u0426-1");
        allowRoutes.add("22 \u041b\u0435\u0434. \u0434\u0432\u043e\u0440\u0435\u0446-\u041f\u043e\u0434\u0441\u0442\u0430\u043d\u0446\u0438\u044f");
        allowRoutes.add("43 \u0421\u0435\u0432 \u0410\u0412- \u041d.\u0427\u0435\u0440\u043a\u0430\u0441\u0441\u044b");
        allowRoutes.add("34 \u0413\u0438\u043b\u0451\u0432\u043e-\u0423\u0437\u043b\u043e\u0432\u0430\u044f \u0430\u0432\u0442\u043e\u0431\u0430\u0437");
        allowRoutes.add("39 \u0411\u0430\u0448\u043a\u043e\u0440\u0442\u043e\u0441\u0442\u0430\u043d-\u0421\u0438\u043f\u0430\u0439\u043b\u043e\u0432\u043e");
        allowRoutes.add("10 \u0414\u043e\u043a-\u043f. \u041c\u0430\u043a\u0441\u0438\u043c\u043e\u0432\u043a\u0430");
        allowRoutes.add("51 \u0412\u0410\u0417 - \u0422\u0440\u0438\u043a. \u0444-\u043a\u0430");
        allowRoutes.add("110 \u0412\u0410\u0417-\u0410\u044d\u0440\u043e\u043f\u043e\u0440\u0442");
        allowRoutes.add("75\u042d \u041e\u043a \u0421\u0438\u043f- \u0422\u0435\u043b\u0435\u0446\u0435\u043d\u0442\u0440");
        allowRoutes.add("75 \u041e\u041a \u0421\u0438\u043f\u0430\u0439\u043b\u043e\u0432\u0441\u043a\u0438\u0439 - \u0426\u0423\u041c");
        allowRoutes.add("13 \u0414\u0437\u0435\u0440\u0436\u0438\u043d\u0441\u043a\u043e\u0433\u043e-\u0411\u0435\u043b\u043e\u0440\u0435\u0447\u0435\u043d");
        allowRoutes.add("57\u0430 \u0423\u0423\u0411\u0420 - \u0411\u043e\u043b\u044c\u043d\u0438\u0446\u0430 \u2116 21");
        allowRoutes.add("22\u0430\u041b\u0435\u0434. \u0434\u0432\u043e\u0440\u0435\u0446-\u041f\u043e\u0434\u0441\u0442\u0430\u043d\u0446\u0438\u044f");
        allowRoutes.add("226 \u0414\u043e\u043a-\u0411\u0413\u0423");
        allowRoutes.add("110\u0441 \u0414\u043e\u043a-\u0410\u044d\u0440\u043e\u043f\u0440\u0442");
        allowRoutes.add("35 \u0414\u041a \u0423\u041c\u041f\u041e-\u0428\u0430\u043a\u0448\u0430-2");
        allowRoutes.add("51 \"\u0410\"\u0412\u0410\u0417 - \u0422\u0440\u0438\u043a. \u0444-\u043a\u0430");
        allowRoutes.add("14 \u0414\u0430\u0433\u0435\u0441\u0442\u0430\u043d\u0441\u043a\u0430\u044f - \u0426\u0423\u041c");
    }

    private static class Routes {
        public String id;
        public String name;
        public HashMap<Integer, Node> stops = new HashMap();
        public ArrayList<String> schedule = new ArrayList();

        private Routes() {
        }
    }
}

