/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.tests;

import java.io.IOException;
import java.io.PrintStream;
import ru.concel.routing.astar.AStar;
import ru.concel.routing.astar.PathNode;
import ru.concel.routing.astar.fitness.PathCalculator;
import ru.concel.routing.astar.path.CalculatedPath;
import ru.concel.routing.map.RoutingMap;
import ru.concel.routing.spatialdata.SpatialDataReader;

public class TestAStar {
    public static void main(String[] args) {
        System.out.println("Map initializing...");
        try {
            RoutingMap map = SpatialDataReader.getMap("spatial/");
            System.out.println("Heuristic initializing...");
            PathCalculator heuristic = new PathCalculator();
            System.out.println("AStar initializing...");
            AStar aStar = new AStar(map, heuristic);
            System.out.println("Calculating shortest path...");
            CalculatedPath shortestPath = null;
            for (int i = 0; i < 1000; ++i) {
                double s = System.currentTimeMillis();
                shortestPath = aStar.calcShortestPathJSON(56.07902526855469, 54.767820284397445, 55.90049743652344, 54.74146974761669, 0L, new Long[]{1L, 0L}, null);
                s = (double)System.currentTimeMillis() - s;
                System.out.println("Time to calculate path in milliseconds: " + s);
                if (shortestPath instanceof CalculatedPath) {
                    CalculatedPath cp = shortestPath;
                    System.out.println("\u0421\u0435\u0433\u043c\u0435\u043d\u0442\u043e\u0432 " + cp.getSegments().length);
                }
                s = System.currentTimeMillis();
            }
            TestAStar.writeGPX(System.out, shortestPath);
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430");
            e.printStackTrace();
        }
    }

    private static void writeGPX(PrintStream f0, Object sp) throws IOException {
        if (sp instanceof PathNode) {
            PathNode shortestPath = (PathNode)sp;
            f0.println("<?xml version='1.0' encoding='UTF-8'?>");
            f0.println("<gpx>");
            f0.println("  <trk>");
            f0.println("    <trkseg>");
            do {
                f0.println("      <trkpt lat=\"" + shortestPath.getNode().getLat() + "\" lon=\"" + shortestPath.getNode().getLon() + "\"/>");
            } while ((shortestPath = shortestPath.getPreviousNode()) != null);
            f0.println("    </trkseg>");
            f0.println("  </trk>");
            f0.println("</gpx>");
            f0.close();
        }
    }
}

