/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Group;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Marker
extends Group {
    AffineTransform viewXform;
    AffineTransform markerXform;
    Rectangle2D viewBox;
    float refX;
    float refY;
    float markerWidth = 3.0f;
    float markerHeight = 3.0f;
    float orient = Float.NaN;
    public static final int MARKER_START = 0;
    public static final int MARKER_MID = 1;
    public static final int MARKER_END = 2;

    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("refX"))) {
            this.refX = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("refY"))) {
            this.refY = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("markerWidth"))) {
            this.markerWidth = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("markerHeight"))) {
            this.markerHeight = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("orient"))) {
            this.orient = "auto".equals(styleAttribute.getStringValue()) ? Float.NaN : styleAttribute.getFloatValue();
        }
        if (this.getPres(styleAttribute.setName("viewBox"))) {
            float[] fArray = styleAttribute.getFloatList();
            this.viewBox = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        if (this.viewBox == null) {
            this.viewBox = new Rectangle(0, 0, 1, 1);
        }
        this.viewXform = new AffineTransform();
        this.viewXform.scale(1.0 / this.viewBox.getWidth(), 1.0 / this.viewBox.getHeight());
        this.viewXform.translate(-this.viewBox.getX(), -this.viewBox.getY());
        this.markerXform = new AffineTransform();
        this.markerXform.scale(this.markerWidth, this.markerHeight);
        this.markerXform.concatenate(this.viewXform);
        this.markerXform.translate(-this.refX, -this.refY);
    }

    protected boolean outsideClip(Graphics2D graphics2D) throws SVGException {
        graphics2D.getClipBounds(this.clipBounds);
        Rectangle2D rectangle2D = super.getBoundingBox();
        return !rectangle2D.intersects(this.clipBounds);
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.markerXform);
        super.render(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    public void render(Graphics2D graphics2D, MarkerPos markerPos, float f) throws SVGException {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(markerPos.x, markerPos.y);
        graphics2D.scale(f, f);
        graphics2D.rotate(Math.atan2(markerPos.dy, markerPos.dx));
        graphics2D.transform(this.markerXform);
        super.render(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    public Shape getShape() {
        Shape shape = super.getShape();
        return this.markerXform.createTransformedShape(shape);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        Rectangle2D rectangle2D = super.getBoundingBox();
        return this.markerXform.createTransformedShape(rectangle2D).getBounds2D();
    }

    public boolean updateTime(double d) throws SVGException {
        boolean bl = super.updateTime(d);
        return bl;
    }

    public static class MarkerLayout {
        private ArrayList markerList = new ArrayList();
        boolean started = false;

        public void layout(Shape shape) {
            double d = 0.0;
            double d2 = 0.0;
            double[] dArray = new double[6];
            PathIterator pathIterator = shape.getPathIterator(null);
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(dArray)) {
                    case 0: {
                        d = dArray[0];
                        d2 = dArray[1];
                        this.started = false;
                        break;
                    }
                    case 4: {
                        this.started = false;
                        break;
                    }
                    case 1: {
                        double d3 = dArray[0];
                        double d4 = dArray[1];
                        this.markerIn(d, d2, d3 - d, d4 - d2);
                        this.markerOut(d3, d4, d3 - d, d4 - d2);
                        d = d3;
                        d2 = d4;
                        break;
                    }
                    case 2: {
                        double d3 = dArray[0];
                        double d4 = dArray[1];
                        double d5 = dArray[2];
                        double d6 = dArray[3];
                        this.markerIn(d, d2, d3 - d, d4 - d2);
                        this.markerOut(d5, d6, d5 - d3, d6 - d4);
                        d = d5;
                        d2 = d6;
                        break;
                    }
                    case 3: {
                        double d3 = dArray[0];
                        double d4 = dArray[1];
                        double d5 = dArray[2];
                        double d6 = dArray[3];
                        double d7 = dArray[4];
                        double d8 = dArray[5];
                        this.markerIn(d, d2, d3 - d, d4 - d2);
                        this.markerOut(d7, d8, d7 - d5, d8 - d6);
                        d = d7;
                        d2 = d8;
                        break;
                    }
                }
                pathIterator.next();
            }
            for (int i = 1; i < this.markerList.size(); ++i) {
                MarkerPos markerPos = (MarkerPos)this.markerList.get(i - 1);
                MarkerPos markerPos2 = (MarkerPos)this.markerList.get(i);
                if (markerPos2.type != 0) continue;
                markerPos.type = 2;
            }
            MarkerPos markerPos = (MarkerPos)this.markerList.get(this.markerList.size() - 1);
            markerPos.type = 2;
        }

        private void markerIn(double d, double d2, double d3, double d4) {
            if (!this.started) {
                this.started = true;
                this.markerList.add(new MarkerPos(0, d, d2, d3, d4));
            }
        }

        private void markerOut(double d, double d2, double d3, double d4) {
            this.markerList.add(new MarkerPos(1, d, d2, d3, d4));
        }

        public ArrayList getMarkerList() {
            return this.markerList;
        }
    }

    public static class MarkerPos {
        int type;
        double x;
        double y;
        double dx;
        double dy;

        public MarkerPos(int n, double d, double d2, double d3, double d4) {
            this.type = n;
            this.x = d;
            this.y = d2;
            this.dx = d3;
            this.dy = d4;
        }
    }
}

