/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.pathcmd;

import com.kitfox.svg.pathcmd.BuildHistory;
import com.kitfox.svg.pathcmd.PathCommand;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

public class Arc
extends PathCommand {
    public float rx = 0.0f;
    public float ry = 0.0f;
    public float xAxisRot = 0.0f;
    public boolean largeArc = false;
    public boolean sweep = false;
    public float x = 0.0f;
    public float y = 0.0f;

    public Arc() {
    }

    public Arc(boolean bl, float f, float f2, float f3, boolean bl2, boolean bl3, float f4, float f5) {
        super(bl);
        this.rx = f;
        this.ry = f2;
        this.xAxisRot = f3;
        this.largeArc = bl2;
        this.sweep = bl3;
        this.x = f4;
        this.y = f5;
    }

    public void appendPath(GeneralPath generalPath, BuildHistory buildHistory) {
        float f = this.isRelative ? buildHistory.history[0].x : 0.0f;
        float f2 = this.isRelative ? buildHistory.history[0].y : 0.0f;
        this.arcTo(generalPath, this.rx, this.ry, this.xAxisRot, this.largeArc, this.sweep, this.x + f, this.y + f2, buildHistory.history[0].x, buildHistory.history[0].y);
        buildHistory.setPoint(this.x + f, this.y + f2);
    }

    public int getNumKnotsAdded() {
        return 6;
    }

    public void arcTo(GeneralPath generalPath, float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5, float f6, float f7) {
        if (f == 0.0f || f2 == 0.0f) {
            generalPath.lineTo(f4, f5);
            return;
        }
        if (f6 == f4 && f7 == f5) {
            return;
        }
        Arc2D arc2D = Arc.computeArc(f6, f7, f, f2, f3, bl, bl2, f4, f5);
        if (arc2D == null) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f3), arc2D.getCenterX(), arc2D.getCenterY());
        Shape shape = affineTransform.createTransformedShape(arc2D);
        generalPath.append(shape, true);
    }

    public static Arc2D computeArc(double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, double d6, double d7) {
        double d8;
        double d9;
        double d10 = (d - d6) / 2.0;
        double d11 = (d2 - d7) / 2.0;
        d5 = Math.toRadians(d5 % 360.0);
        double d12 = Math.cos(d5);
        double d13 = Math.sin(d5);
        double d14 = d12 * d10 + d13 * d11;
        double d15 = -d13 * d10 + d12 * d11;
        double d16 = d14 * d14;
        double d17 = (d3 = Math.abs(d3)) * d3;
        double d18 = d16 / d17 + (d9 = d15 * d15) / (d8 = (d4 = Math.abs(d4)) * d4);
        if (d18 > 1.0) {
            d3 = Math.sqrt(d18) * d3;
            d4 = Math.sqrt(d18) * d4;
            d17 = d3 * d3;
            d8 = d4 * d4;
        }
        double d19 = bl == bl2 ? -1.0 : 1.0;
        double d20 = (d17 * d8 - d17 * d9 - d8 * d16) / (d17 * d9 + d8 * d16);
        d20 = d20 < 0.0 ? 0.0 : d20;
        double d21 = d19 * Math.sqrt(d20);
        double d22 = d21 * (d3 * d15 / d4);
        double d23 = d21 * -(d4 * d14 / d3);
        double d24 = (d + d6) / 2.0;
        double d25 = (d2 + d7) / 2.0;
        double d26 = d24 + (d12 * d22 - d13 * d23);
        double d27 = d25 + (d13 * d22 + d12 * d23);
        double d28 = (d14 - d22) / d3;
        double d29 = (d15 - d23) / d4;
        double d30 = (-d14 - d22) / d3;
        double d31 = (-d15 - d23) / d4;
        double d32 = Math.sqrt(d28 * d28 + d29 * d29);
        double d33 = d28;
        d19 = d29 < 0.0 ? -1.0 : 1.0;
        double d34 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        d32 = Math.sqrt((d28 * d28 + d29 * d29) * (d30 * d30 + d31 * d31));
        d33 = d28 * d30 + d29 * d31;
        d19 = d28 * d31 - d29 * d30 < 0.0 ? -1.0 : 1.0;
        double d35 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        if (!bl2 && d35 > 0.0) {
            d35 -= 360.0;
        } else if (bl2 && d35 < 0.0) {
            d35 += 360.0;
        }
        d35 %= 360.0;
        d34 %= 360.0;
        Arc2D.Double double_ = new Arc2D.Double();
        double_.x = d26 - d3;
        double_.y = d27 - d4;
        double_.width = d3 * 2.0;
        double_.height = d4 * 2.0;
        double_.start = -d34;
        double_.extent = -d35;
        return double_;
    }
}

