/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambertCC9Zones
extends AbstractProjection
implements ProjectionSubPrefs {
    public static final double cMaxLatZonesRadian = Math.toRadians(51.1);
    public static final double cMinLatZonesDegree = 41.0;
    public static final double cMaxOverlappingZones = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private int layoutZone = 0;
    private static String[] lambert9zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, 41, 43), I18n.tr("{0} ({1} to {2} degrees)", 2, 42, 44), I18n.tr("{0} ({1} to {2} degrees)", 3, 43, 45), I18n.tr("{0} ({1} to {2} degrees)", 4, 44, 46), I18n.tr("{0} ({1} to {2} degrees)", 5, 45, 47), I18n.tr("{0} ({1} to {2} degrees)", 6, 46, 48), I18n.tr("{0} ({1} to {2} degrees)", 7, 47, 49), I18n.tr("{0} ({1} to {2} degrees)", 8, 48, 50), I18n.tr("{0} ({1} to {2} degrees)", 9, 49, 51)};

    public LambertCC9Zones() {
        this(0);
    }

    public LambertCC9Zones(int n) {
        this.updateParameters(n);
    }

    public void updateParameters(final int n) {
        this.ellps = Ellipsoid.GRS80;
        this.datum = GRS80Datum.INSTANCE;
        this.layoutZone = n;
        this.x_0 = 1700000.0;
        this.y_0 = (n + 1) * 1000000 + 200000;
        this.lon_0 = 3.0;
        if (this.proj == null) {
            this.proj = new LambertConformalConic();
        }
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = LambertCC9Zones.this.ellps;
                    this.lat_0 = 42.0 + (double)n;
                    this.lat_1 = 41.25 + (double)n;
                    this.lat_2 = 42.75 + (double)n;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
    }

    @Override
    public String toString() {
        return I18n.tr("Lambert CC9 Zone (France)", new Object[0]);
    }

    public static int north2ZoneNumber(double d) {
        int n = (int)(d / 1000000.0) - 1;
        if (n < 0) {
            return 0;
        }
        if (n > 8) {
            return 8;
        }
        return n;
    }

    @Override
    public Integer getEpsgCode() {
        return 3942 + this.layoutZone;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.layoutZone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "lambert";
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        double d = 41.0 + (double)(this.layoutZone + 1);
        return new Bounds(new LatLon(Math.max(d - 1.0 - 1.5, 41.0), -5.5), new LatLon(Math.min(d + 1.0 + 1.5, Math.toDegrees(cMaxLatZonesRadian)), 10.2));
    }

    public int getLayoutZone() {
        return this.layoutZone;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JComboBox<String> jComboBox = new JComboBox<String>(lambert9zones);
        jComboBox.setSelectedIndex(this.layoutZone);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Lambert CC Zone", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add((Component)new JLabel(ImageProvider.get("data/projection", "LambertCC9Zones.png")), GBC.eol().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        int n = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Integer.toString(n + 1));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        int n = 0;
        if (collection != null) {
            try {
                String string;
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext() && ((n = Integer.parseInt(string = iterator.next()) - 1) < 0 || n > 8)) {
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.updateParameters(n);
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[9];
        for (int i = 0; i < 9; ++i) {
            stringArray[i] = "EPSG:" + (3942 + i);
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:39") && string.length() == 9) {
            try {
                String string2 = string.substring(5, 9);
                int n = Integer.parseInt(string2) - 3942;
                if (n >= 0 && n <= 8) {
                    return Collections.singleton(String.valueOf(n + 1));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

