/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Epsg2176;
import org.openstreetmap.josm.data.projection.Epsg2177;
import org.openstreetmap.josm.data.projection.Epsg2178;
import org.openstreetmap.josm.data.projection.Epsg2179;
import org.openstreetmap.josm.data.projection.Epsg2180;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.PuwgData;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Puwg
extends AbstractProjection
implements ProjectionSubPrefs {
    public static final int DEFAULT_ZONE = 0;
    private int zone;
    static PuwgData[] Zones = new PuwgData[]{new Epsg2180(), new Epsg2176(), new Epsg2177(), new Epsg2178(), new Epsg2179()};

    public Puwg() {
        this(0);
    }

    public Puwg(int n) {
        this.ellps = Ellipsoid.GRS80;
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = Puwg.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.datum = GRS80Datum.INSTANCE;
        this.updateParameters(n);
    }

    public void updateParameters(int n) {
        this.zone = n;
        PuwgData puwgData = Zones[n];
        this.x_0 = puwgData.getPuwgFalseEasting();
        this.y_0 = puwgData.getPuwgFalseNorthing();
        this.lon_0 = puwgData.getPuwgCentralMeridianDeg();
        this.k_0 = puwgData.getPuwgScaleFactor();
    }

    @Override
    public String toString() {
        return I18n.tr("PUWG (Poland)", new Object[0]);
    }

    @Override
    public Integer getEpsgCode() {
        return Zones[this.zone].getEpsgCode();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.zone;
    }

    @Override
    public String getCacheDirectoryName() {
        return Zones[this.zone].getCacheDirectoryName();
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return Zones[this.zone].getWorldBoundsLatLon();
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JComboBox<PuwgData> jComboBox = new JComboBox<PuwgData>(Zones);
        jComboBox.setSelectedIndex(this.zone);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("PUWG Zone", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        int n = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Zones[n].toCode());
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[Zones.length];
        for (int i = 0; i < Zones.length; ++i) {
            stringArray[i] = Zones[i].toCode();
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (PuwgData puwgData : Zones) {
            if (!string.equals(puwgData.toCode())) continue;
            return Collections.singleton(string);
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        int n;
        block4: {
            n = 0;
            if (collection != null) {
                try {
                    Iterator<String> iterator = collection.iterator();
                    if (!iterator.hasNext()) break block4;
                    String string = iterator.next();
                    for (int i = 0; i < Zones.length; ++i) {
                        if (!string.equals(Zones[i].toCode())) continue;
                        n = i;
                        break;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        this.updateParameters(n);
    }
}

