/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.text.MessageFormat;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class JosmUserIdentityManager
implements Preferences.PreferenceChangedListener {
    private static JosmUserIdentityManager instance;
    private String userName;
    private UserInfo userInfo;

    public static JosmUserIdentityManager getInstance() {
        if (instance == null) {
            instance = new JosmUserIdentityManager();
            instance.initFromPreferences();
            Main.pref.addPreferenceChangeListener(instance);
        }
        return instance;
    }

    private JosmUserIdentityManager() {
    }

    public void setAnonymous() {
        this.userName = null;
        this.userInfo = null;
    }

    public void setPartiallyIdentified(String string) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(string, "userName");
        if (string.trim().equals("")) {
            throw new IllegalArgumentException(MessageFormat.format("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", string));
        }
        this.userName = string;
        this.userInfo = null;
    }

    public void setFullyIdentified(String string, UserInfo userInfo) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(string, "username");
        if (string.trim().equals("")) {
            throw new IllegalArgumentException(I18n.tr("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", this.userName));
        }
        CheckParameterUtil.ensureParameterNotNull(userInfo, "userinfo");
        this.userName = string;
        this.userInfo = userInfo;
    }

    public boolean isAnonymous() {
        return this.userName == null && this.userInfo == null;
    }

    public boolean isPartiallyIdentified() {
        return this.userName != null && this.userInfo == null;
    }

    public boolean isFullyIdentified() {
        return this.userName != null && this.userInfo != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUserId() {
        if (this.userInfo == null) {
            return 0;
        }
        return this.userInfo.getId();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void initFromPreferences() {
        String string = CredentialsManager.getInstance().getUsername();
        if (this.isAnonymous()) {
            if (string != null && !string.trim().equals("")) {
                this.setPartiallyIdentified(string);
            }
        } else if (!string.equals(this.userName)) {
            this.setPartiallyIdentified(string);
        }
    }

    public boolean isCurrentUser(String string) {
        if (string == null || this.userName == null) {
            return false;
        }
        return this.userName.equals(string);
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals("osm-server.username")) {
            if (!(preferenceChangeEvent.getNewValue() instanceof Preferences.StringSetting)) {
                return;
            }
            String string = (String)((Preferences.StringSetting)preferenceChangeEvent.getNewValue()).getValue();
            if (string == null || string.trim().length() == 0) {
                this.setAnonymous();
            } else if (!string.equals(this.userName)) {
                this.setPartiallyIdentified(string);
            }
            return;
        }
        if (preferenceChangeEvent.getKey().equals("osm-server.url")) {
            if (!(preferenceChangeEvent.getNewValue() instanceof Preferences.StringSetting)) {
                return;
            }
            String string = (String)((Preferences.StringSetting)preferenceChangeEvent.getNewValue()).getValue();
            if (string == null || string.trim().equals("")) {
                this.setAnonymous();
            } else if (this.isFullyIdentified()) {
                this.setPartiallyIdentified(this.getUserName());
            }
        }
    }
}

