/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Graphics;
import java.awt.Point;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.ImageProvider;

public class SizeButton {
    private int x = 0;
    private int y = 0;
    private ImageIcon enlargeImage = ImageProvider.get("view-fullscreen.png");
    private ImageIcon shrinkImage = ImageProvider.get("view-fullscreen-revert.png");
    private boolean isEnlarged = false;

    public void paint(Graphics graphics) {
        if (this.isEnlarged) {
            if (this.shrinkImage != null) {
                graphics.drawImage(this.shrinkImage.getImage(), this.x, this.y, null);
            }
        } else if (this.enlargeImage != null) {
            graphics.drawImage(this.enlargeImage.getImage(), this.x, this.y, null);
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
    }

    public boolean isEnlarged() {
        return this.isEnlarged;
    }

    public boolean hit(Point point) {
        return this.x < point.x && point.x < this.x + this.enlargeImage.getIconWidth() && this.y < point.y && point.y < this.y + this.enlargeImage.getIconHeight();
    }
}

