/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadAndZoomHandler
extends RequestHandler {
    public static final String command = "load_and_zoom";
    public static final String command2 = "zoom";

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load data from the API.", new Object[0]) + "<br>" + I18n.tr("Request details: {0}", this.request);
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"bottom", "top", "left", "right"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            d = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("bottom")));
            d2 = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("top")));
            d3 = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("left")));
            d4 = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("right")));
            boolean bl = this.isLoadInNewLayer();
            if (command.equals(this.myCommand)) {
                if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
                    System.out.println("RemoteControl: download forbidden by preferences");
                } else {
                    Object object;
                    Area area = null;
                    if (!bl) {
                        object = null;
                        DataSet dataSet = Main.main.getCurrentDataSet();
                        if (dataSet != null) {
                            object = dataSet.getDataSourceArea();
                        }
                        if (object != null && !((Area)object).isEmpty()) {
                            area = new Area(new Rectangle2D.Double(d3, d, d4 - d3, d2 - d));
                            area.subtract((Area)object);
                            if (!area.isEmpty()) {
                                Rectangle2D rectangle2D = area.getBounds2D();
                                d = rectangle2D.getMinY();
                                d3 = rectangle2D.getMinX();
                                d2 = rectangle2D.getMaxY();
                                d4 = rectangle2D.getMaxX();
                            }
                        }
                    }
                    if (area != null && area.isEmpty()) {
                        System.out.println("RemoteControl: no download necessary");
                    } else {
                        object = downloadOsmTask.download(bl, new Bounds(d, d3, d2, d4), null);
                        Main.worker.submit(new PostDownloadHandler((DownloadTask)downloadOsmTask, (Future<?>)object));
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("RemoteControl: Error parsing load_and_zoom remote control request:");
            exception.printStackTrace();
            throw new RequestHandler.RequestHandlerErrorException();
        }
        if (this.args.containsKey("addtags")) {
            Main.worker.execute(new Runnable(){

                public void run() {
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    if (dataSet == null) {
                        return;
                    }
                    dataSet.clearSelection();
                }
            });
        }
        if (this.args.containsKey("select") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            final String string = (String)this.args.get("select");
            Main.worker.execute(new Runnable(){

                public void run() {
                    HashSet<Long> hashSet = new HashSet<Long>();
                    HashSet<Long> hashSet2 = new HashSet<Long>();
                    HashSet<Long> hashSet3 = new HashSet<Long>();
                    HashSet<OsmPrimitive> hashSet4 = new HashSet<OsmPrimitive>();
                    for (String string2 : string.split(",")) {
                        if (string2.startsWith("way")) {
                            hashSet.add(Long.parseLong(string2.substring(3)));
                            continue;
                        }
                        if (string2.startsWith("node")) {
                            hashSet2.add(Long.parseLong(string2.substring(4)));
                            continue;
                        }
                        if (string2.startsWith("relation")) {
                            hashSet3.add(Long.parseLong(string2.substring(8)));
                            continue;
                        }
                        if (string2.startsWith("rel")) {
                            hashSet3.add(Long.parseLong(string2.substring(3)));
                            continue;
                        }
                        System.out.println("RemoteControl: invalid selection '" + string2 + "' ignored");
                    }
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    if (dataSet == null) {
                        return;
                    }
                    for (Way way : dataSet.getWays()) {
                        if (!hashSet.contains(way.getId())) continue;
                        hashSet4.add(way);
                    }
                    for (Node node : dataSet.getNodes()) {
                        if (!hashSet2.contains(node.getId())) continue;
                        hashSet4.add(node);
                    }
                    for (Relation relation : dataSet.getRelations()) {
                        if (!hashSet3.contains(relation.getId())) continue;
                        hashSet4.add(relation);
                    }
                    dataSet.setSelected(hashSet4);
                    if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
                        AutoScaleAction.autoScale("selection");
                    }
                    if (Main.map != null && Main.map.relationListDialog != null) {
                        Main.map.relationListDialog.selectRelations(null);
                        Main.map.relationListDialog.dataChanged(null);
                        Main.map.relationListDialog.selectRelations(Utils.filteredCollection(hashSet4, Relation.class));
                    }
                }
            });
        } else if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            this.zoom(d, d2, d3, d4);
        }
        LoadAndZoomHandler.addTags(this.args);
    }

    static void addTags(final Map<String, String> map) {
        if (map.containsKey("addtags")) {
            Main.worker.execute(new Runnable(){

                public void run() {
                    String[] stringArray = null;
                    try {
                        stringArray = URLDecoder.decode((String)map.get("addtags"), "UTF-8").split("\\|");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new RuntimeException();
                    }
                    String[][] stringArray2 = new String[stringArray.length][2];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2[i] = stringArray[i].split("=");
                        stringArray2[i][0] = stringArray2[i][0];
                        stringArray2[i][1] = stringArray2[i][1];
                    }
                    new AddTagsDialog(stringArray2);
                }
            });
        }
    }

    protected void zoom(double d, double d2, double d3, double d4) {
        final Bounds bounds = new Bounds(new LatLon(d, d3), new LatLon(d2, d4));
        if (Main.map != null && Main.map.mapView != null) {
            Main.worker.execute(new Runnable(){

                public void run() {
                    BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                    boundingXYVisitor.visit(bounds);
                    Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
                }
            });
        }
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }
}

