/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.client.soap.proxy.analytics;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import ru.infor.client.ServicesConnection;
import ru.infor.client.soap.proxy.analytics.Analytic2EntityClassLinkWSProxy;
import ru.infor.client.soap.proxy.analytics.AnalyticWSProxy;
import ru.infor.ws.objects.analytics.entities.Analytic;
import ru.infor.ws.objects.analytics.entities.Analytic2EntityClassLink;
import ru.infor.ws.proxy.UniversalProxy;
import ru.infor.ws.proxy.WSProxyFactory;

public class WSProxyFactoryImpl
implements WSProxyFactory {
    private Map<Class<?>, Class<?>> proxies = new HashMap();
    private Map<Class<?>, UniversalProxy> instanceProxies = new HashMap();
    private Map<Class<?>, Class<?>> entity_2_proxy = new HashMap();
    private static WSProxyFactory instance;
    private ServicesConnection conn;

    private WSProxyFactoryImpl(ServicesConnection conn) {
        if (conn == null) {
            throw new NullPointerException("ServicesConnection is required");
        }
        this.conn = conn;
        this.proxies.put(Analytic.class, AnalyticWSProxy.class);
        this.proxies.put(Analytic2EntityClassLink.class, Analytic2EntityClassLinkWSProxy.class);
        this.buildEntity2ProxyMap();
    }

    public static WSProxyFactory getInstance(ServicesConnection conn) {
        if (instance == null) {
            instance = new WSProxyFactoryImpl(conn);
        } else if (!((WSProxyFactoryImpl)WSProxyFactoryImpl.instance).conn.equals((Object)conn)) {
            instance = new WSProxyFactoryImpl(conn);
        }
        return instance;
    }

    @Deprecated
    public static WSProxyFactory getInstance() {
        return WSProxyFactoryImpl.getInstance(null);
    }

    private void buildEntity2ProxyMap() {
        for (Map.Entry<Class<?>, Class<?>> e : this.proxies.entrySet()) {
            this.entity_2_proxy.put(e.getValue(), e.getKey());
        }
    }

    public Class<?> getEntity(Class<?> proxyClass) {
        return this.entity_2_proxy.get(proxyClass);
    }

    public UniversalProxy getProxy(Class<?> clazz) {
        Class<?> prc = this.proxies.get(clazz);
        if (prc == null) {
            prc = this.proxies.get(clazz.getSuperclass());
        }
        return this.getProxyInstance(prc);
    }

    private UniversalProxy getProxyInstance(Class<?> prc) {
        try {
            if (this.instanceProxies.containsKey(prc)) {
                return this.instanceProxies.get(prc);
            }
            if (prc != null) {
                Constructor<?> c = prc.getConstructor(ServicesConnection.class);
                UniversalProxy proxy = (UniversalProxy)c.newInstance(this.conn);
                this.instanceProxies.put(prc, proxy);
                return proxy;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Boolean isProxyRegistered(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.proxies.containsKey(obj.getClass()) || this.proxies.containsKey(obj.getClass().getSuperclass());
    }
}

