/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.ProposedEntity;
import org.castor.util.Messages;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLQuery;
import org.exolab.castor.jdo.engine.SQLStatementCreate;
import org.exolab.castor.jdo.engine.SQLStatementLoad;
import org.exolab.castor.jdo.engine.SQLStatementRemove;
import org.exolab.castor.jdo.engine.SQLStatementStore;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;

public final class SQLEngine
implements Persistence {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$jdo$engine$SQLEngine == null ? (class$org$exolab$castor$jdo$engine$SQLEngine = SQLEngine.class$("org.exolab.castor.jdo.engine.SQLEngine")) : class$org$exolab$castor$jdo$engine$SQLEngine));
    private final SQLFieldInfo[] _fields;
    private final SQLColumnInfo[] _ids;
    private SQLEngine _extends;
    private final PersistenceFactory _factory;
    private final JDOClassDescriptor _clsDesc;
    private KeyGenerator _keyGen;
    private final SQLStatementLoad _loadStatement;
    private final SQLStatementCreate _createStatement;
    private final SQLStatementRemove _removeStatement;
    private final SQLStatementStore _storeStatement;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$SQLEngine;

    SQLEngine(JDOClassDescriptor clsDesc, PersistenceFactory factory, String stampField) throws MappingException {
        KeyGeneratorDescriptor keyGenDesc;
        this._clsDesc = clsDesc;
        this._factory = factory;
        this._keyGen = null;
        if (this._clsDesc.getExtends() == null && (keyGenDesc = clsDesc.getKeyGeneratorDescriptor()) != null) {
            int[] tempType = ((JDOFieldDescriptor)this._clsDesc.getIdentity()).getSQLType();
            this._keyGen = keyGenDesc.getKeyGeneratorRegistry().getKeyGenerator(this._factory, keyGenDesc, tempType == null ? 0 : tempType[0]);
            this._keyGen.supportsSqlType(tempType[0]);
        }
        Vector<SQLColumnInfo> idsInfo = new Vector<SQLColumnInfo>();
        Vector<SQLFieldInfo> fieldsInfo = new Vector<SQLFieldInfo>();
        JDOClassDescriptor base = clsDesc;
        base = clsDesc;
        Stack<JDOClassDescriptor> stack = new Stack<JDOClassDescriptor>();
        stack.push(base);
        while (base.getExtends() != null) {
            base = (JDOClassDescriptor)base.getExtends();
            stack.push(base);
        }
        FieldDescriptor[] baseIdDescriptors = base.getIdentities();
        FieldDescriptor[] idDescriptors = clsDesc.getIdentities();
        for (int i = 0; i < baseIdDescriptors.length; ++i) {
            FieldHandlerImpl fh;
            int[] sqlType;
            String[] sqlName;
            if (baseIdDescriptors[i] instanceof JDOFieldDescriptor) {
                String name = baseIdDescriptors[i].getFieldName();
                sqlName = ((JDOFieldDescriptor)baseIdDescriptors[i]).getSQLName();
                sqlType = ((JDOFieldDescriptor)baseIdDescriptors[i]).getSQLType();
                fh = (FieldHandlerImpl)baseIdDescriptors[i].getHandler();
                for (int j = 0; j < idDescriptors.length; ++j) {
                    if (!name.equals(idDescriptors[j].getFieldName()) || !(idDescriptors[j] instanceof JDOFieldDescriptor)) continue;
                    sqlName = ((JDOFieldDescriptor)idDescriptors[j]).getSQLName();
                    break;
                }
            } else {
                throw new MappingException("Except JDOFieldDescriptor");
            }
            idsInfo.add(new SQLColumnInfo(sqlName[0], sqlType[0], fh.getConvertTo(), fh.getConvertFrom(), fh.getConvertParam()));
        }
        while (!stack.empty()) {
            base = (JDOClassDescriptor)stack.pop();
            FieldDescriptor[] fieldDescriptors = base.getFields();
            for (int i = 0; i < fieldDescriptors.length; ++i) {
                if (fieldDescriptors[i].isTransient() || !(fieldDescriptors[i] instanceof JDOFieldDescriptor) && fieldDescriptors[i].getClassDescriptor() == null) continue;
                fieldsInfo.add(new SQLFieldInfo(clsDesc, fieldDescriptors[i], base.getTableName(), !stack.empty()));
            }
        }
        this._ids = new SQLColumnInfo[idsInfo.size()];
        idsInfo.copyInto(this._ids);
        this._fields = new SQLFieldInfo[fieldsInfo.size()];
        fieldsInfo.copyInto(this._fields);
        this._loadStatement = new SQLStatementLoad(this, factory);
        this._createStatement = new SQLStatementCreate(this, factory);
        this._removeStatement = new SQLStatementRemove(this, factory);
        this._storeStatement = new SQLStatementStore(this, factory, this._loadStatement.getLoadStatement());
    }

    public SQLColumnInfo[] getColumnInfoForIdentities() {
        return this._ids;
    }

    public SQLFieldInfo[] getInfo() {
        return this._fields;
    }

    public void setExtends(SQLEngine engine) {
        this._extends = engine;
    }

    public SQLEngine getExtends() {
        return this._extends;
    }

    public JDOClassDescriptor getDescriptor() {
        return this._clsDesc;
    }

    public PersistenceQuery createQuery(QueryExpression query, Class[] types, AccessMode accessMode) throws QueryException {
        AccessMode mode = accessMode != null ? accessMode : this._clsDesc.getAccessMode();
        String sql = query.getStatement(mode == AccessMode.DbLocked);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format("jdo.createSql", sql));
        }
        return new SQLQuery(this, this._factory, sql, types, false);
    }

    public PersistenceQuery createCall(String spCall, Class[] types) {
        if (spCall.startsWith("SQL")) {
            String sql = spCall.substring(4);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format("jdo.directSQL", sql));
            }
            return new SQLQuery(this, this._factory, sql, types, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format("jdo.spCall", spCall));
        }
        FieldDescriptor[] fields = this._clsDesc.getFields();
        String[] jdoFields0 = new String[fields.length + 1];
        int[] sqlTypes0 = new int[fields.length + 1];
        int count = 1;
        jdoFields0[0] = this._clsDesc.getIdentity().getFieldName();
        sqlTypes0[0] = ((JDOFieldDescriptor)this._clsDesc.getIdentity()).getSQLType()[0];
        for (int i = 0; i < fields.length; ++i) {
            if (!(fields[i] instanceof JDOFieldDescriptor)) continue;
            jdoFields0[count] = ((JDOFieldDescriptor)fields[i]).getSQLName()[0];
            sqlTypes0[count] = ((JDOFieldDescriptor)fields[i]).getSQLType()[0];
            ++count;
        }
        String[] jdoFields = new String[count];
        int[] sqlTypes = new int[count];
        System.arraycopy(jdoFields0, 0, jdoFields, 0, count);
        System.arraycopy(sqlTypes0, 0, sqlTypes, 0, count);
        return ((BaseFactory)this._factory).getCallQuery(spCall, types, this._clsDesc.getJavaClass(), jdoFields, sqlTypes);
    }

    public QueryExpression getQueryExpression() {
        return this._factory.getQueryExpression();
    }

    public QueryExpression getFinder() {
        return this._loadStatement.getQueryExpression();
    }

    protected Object idToJava(int index, Object object) {
        if (object == null || this._ids[index].getConvertTo() == null) {
            return object;
        }
        return this._ids[index].getConvertTo().convert(object, this._ids[index].getConvertParam());
    }

    protected Object toJava(int field, int column, Object object) {
        SQLColumnInfo col = this._fields[field].getColumnInfo()[column];
        if (object == null || col.getConvertTo() == null) {
            return object;
        }
        return col.getConvertTo().convert(object, col.getConvertParam());
    }

    public Identity create(Database database, Object conn, ProposedEntity entity, Identity identity) throws PersistenceException {
        return (Identity)this._createStatement.executeStatement(database, (Connection)conn, identity, entity);
    }

    public Object store(Object conn, Identity identity, ProposedEntity newentity, ProposedEntity oldentity) throws PersistenceException {
        return this._storeStatement.executeStatement((Connection)conn, identity, newentity, oldentity);
    }

    public void delete(Object conn, Identity identity) throws PersistenceException {
        this._removeStatement.executeStatement((Connection)conn, identity);
    }

    public Object load(Object conn, ProposedEntity entity, Identity identity, AccessMode accessMode) throws PersistenceException {
        return this._loadStatement.executeStatement((Connection)conn, identity, entity, accessMode);
    }

    public String toString() {
        return this._clsDesc.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

