/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.message;

import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.ws.encoding.soap.message.FaultCode;
import com.sun.xml.ws.encoding.soap.message.FaultCodeEnum;
import com.sun.xml.ws.encoding.soap.message.FaultReason;
import com.sun.xml.ws.encoding.soap.message.FaultReasonText;
import com.sun.xml.ws.encoding.soap.message.FaultSubcode;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.streaming.DOMStreamReader;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.SOAPUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Node;

public class SOAP12FaultInfo
extends SOAPFaultInfo {
    private FaultCode code;
    private FaultReason reason;
    private String node;
    private String role;
    private Object detail;

    public SOAP12FaultInfo(FaultCode code, FaultReason reason, String node, String role, Object detail) {
        this.code = code;
        this.reason = reason;
        this.node = node;
        this.role = role;
        this.detail = detail;
        this.soapFault = SOAPUtil.createSOAPFault("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        this.setFaultCode();
        this.setFaultReason();
        this.setFaultNode();
        this.setFaultRole();
        if (detail != null && detail instanceof Detail) {
            Node n = this.soapFault.getOwnerDocument().importNode((Node)((Detail)detail), true);
            this.soapFault.appendChild(n);
        } else {
            this.faultBean = detail != null ? (JAXBBridgeInfo)detail : null;
        }
    }

    public SOAP12FaultInfo(SOAPFault fault) {
        this.soapFault = fault;
        QName fc = this.soapFault.getFaultCodeAsQName();
        Iterator iter = this.soapFault.getFaultSubcodes();
        this.code = new FaultCode(FaultCodeEnum.get(fc), iter);
        try {
            ArrayList<FaultReasonText> texts = new ArrayList<FaultReasonText>();
            iter = this.soapFault.getFaultReasonLocales();
            while (iter.hasNext()) {
                Locale lang = (Locale)iter.next();
                String text = this.soapFault.getFaultReasonText(lang);
                texts.add(new FaultReasonText(text, lang));
            }
            this.reason = new FaultReason(texts);
            this.node = this.soapFault.getFaultNode();
            this.role = this.soapFault.getFaultRole();
            this.detail = this.soapFault.getDetail();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
    }

    public FaultCode getFaultCode() {
        return this.code;
    }

    public FaultReason getReasons() {
        return this.reason;
    }

    public String getNode() {
        return this.node;
    }

    public String getRole() {
        return this.role;
    }

    private void setFaultRole() {
        if (this.soapFault == null || this.role == null) {
            return;
        }
        try {
            this.soapFault.setFaultRole(this.role);
        }
        catch (SOAPException e) {
            throw new WebServiceException(e);
        }
    }

    private void setFaultNode() {
        if (this.soapFault == null || this.node == null) {
            return;
        }
        try {
            this.soapFault.setFaultNode(this.node);
        }
        catch (SOAPException e) {
            throw new WebServiceException(e);
        }
    }

    private void setFaultReason() {
        if (this.soapFault == null || this.reason == null) {
            return;
        }
        List<FaultReasonText> texts = this.reason.getFaultReasonTexts();
        for (FaultReasonText text : texts) {
            try {
                this.soapFault.addFaultReasonText(text.getValue(), text.getLanguage());
            }
            catch (SOAPException e) {
                throw new WebServiceException(e);
            }
        }
    }

    private void setFaultCode() {
        if (this.soapFault == null || this.code == null) {
            return;
        }
        try {
            this.soapFault.setFaultCode(this.code.getValue().value());
            for (FaultSubcode fsc = this.code.getSubcode(); fsc != null; fsc = fsc.getSubcode()) {
                this.soapFault.appendFaultSubcode(fsc.getValue());
            }
        }
        catch (SOAPException e) {
            throw new WebServiceException(e);
        }
    }

    public void write(XMLStreamWriter writer, MessageInfo mi) {
        try {
            writer.writeStartElement("soapenv", SOAP12Constants.QNAME_SOAP_FAULT.getLocalPart(), SOAP12Constants.QNAME_SOAP_FAULT.getNamespaceURI());
            writer.writeNamespace("soapenv", SOAP12Constants.QNAME_SOAP_FAULT.getNamespaceURI());
            this.code.write(writer);
            this.reason.write(writer);
            if (this.node != null) {
                writer.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_NODE.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
                writer.writeCharacters(this.node);
                writer.writeEndElement();
            }
            if (this.role != null) {
                writer.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_ROLE.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
                writer.writeCharacters(this.role);
                writer.writeEndElement();
            }
            if (this.detail != null) {
                if (this.detail instanceof Detail) {
                    SOAPEncoder.serializeReader(new DOMStreamReader((Node)((Detail)this.detail)), writer);
                } else if (this.detail instanceof JAXBBridgeInfo) {
                    this.startDetailElement(writer);
                    RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(mi);
                    BridgeContext bridgeContext = rtCtxt.getBridgeContext();
                    ((JAXBBridgeInfo)this.detail).serialize(bridgeContext, writer);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new ServerRtException(e);
        }
    }

    private void startDetailElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_DETAIL.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
    }
}

