/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.encoding.jaxb.JAXBTypeSerializer;
import com.sun.xml.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.handler.HandlerException;
import com.sun.xml.ws.handler.SOAPHandlerContext;
import com.sun.xml.ws.pept.ept.MessageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageContextImpl
implements SOAPMessageContext {
    private SOAPHandlerContext handlerCtxt;
    private MessageContext ctxt;
    private Set<String> roles;
    private static Map<String, Class> allowedTypes = null;
    private boolean failure;

    public SOAPMessageContextImpl(SOAPHandlerContext handlerCtxt) {
        this.handlerCtxt = handlerCtxt;
        this.ctxt = handlerCtxt.getMessageContext();
        if (allowedTypes == null) {
            allowedTypes = new HashMap<String, Class>();
            allowedTypes.put("javax.xml.ws.binding.attachments.inbound", Map.class);
            allowedTypes.put("javax.xml.ws.binding.attachments.outbound", Map.class);
            allowedTypes.put("javax.xml.ws.wsdl.description", InputSource.class);
            allowedTypes.put("javax.xml.ws.wsdl.service", QName.class);
            allowedTypes.put("javax.xml.ws.wsdl.port", QName.class);
            allowedTypes.put("javax.xml.ws.wsdl.interface", QName.class);
            allowedTypes.put("javax.xml.ws.wsdl.operation", QName.class);
            allowedTypes.put("javax.xml.ws.handler.message.outbound", Boolean.class);
        }
    }

    @Override
    public SOAPMessage getMessage() {
        SOAPMessage soap = this.handlerCtxt.getSOAPMessage();
        InternalMessage intr = this.handlerCtxt.getInternalMessage();
        if (intr != null || soap == null) {
            if (intr != null && soap != null) {
                MessageInfo messageInfo = this.handlerCtxt.getMessageInfo();
                SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                soap = eptf.getSOAPEncoder().toSOAPMessage(intr, soap);
                this.setMessage(soap);
            } else if (intr != null && soap == null) {
                MessageInfo messageInfo = this.handlerCtxt.getMessageInfo();
                SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                soap = eptf.getSOAPEncoder().toSOAPMessage(intr, messageInfo);
                this.setMessage(soap);
            } else {
                throw new WebServiceException("Don't have SOAPMessage");
            }
        }
        return soap;
    }

    @Override
    public void setMessage(SOAPMessage soapMessage) {
        this.handlerCtxt.setSOAPMessage(soapMessage);
        this.handlerCtxt.setInternalMessage(null);
    }

    @Override
    public Object[] getHeaders(QName header, JAXBContext jaxbContext, boolean allRoles) {
        try {
            ArrayList<Object> beanList = new ArrayList<Object>();
            SOAPMessage msg = this.getMessage();
            SOAPHeader sHeader = msg.getSOAPHeader();
            if (sHeader == null) {
                return new Object[0];
            }
            Iterator i = sHeader.getChildElements(header);
            while (i.hasNext()) {
                DOMSource source;
                SOAPHeaderElement child = (SOAPHeaderElement)i.next();
                if (allRoles) {
                    source = new DOMSource((Node)child);
                    beanList.add(JAXBTypeSerializer.deserialize(source, jaxbContext));
                    continue;
                }
                if (child.getActor() != null && !this.getRoles().contains(child.getActor())) continue;
                source = new DOMSource((Node)child);
                beanList.add(JAXBTypeSerializer.deserialize(source, jaxbContext));
            }
            return beanList.toArray();
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    private boolean validateProperty(String name, Object value) {
        Class clazz;
        if (allowedTypes.containsKey(name) && !(clazz = allowedTypes.get(name)).isInstance(value)) {
            throw new HandlerException("handler.messageContext.invalid.class", value, name);
        }
        return true;
    }

    @Override
    public void setScope(String name, MessageContext.Scope scope) {
        this.ctxt.setScope(name, scope);
    }

    @Override
    public MessageContext.Scope getScope(String name) {
        return this.ctxt.getScope(name);
    }

    @Override
    public void clear() {
        this.ctxt.clear();
    }

    @Override
    public boolean containsKey(Object obj) {
        return this.ctxt.containsKey(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.ctxt.containsValue(obj);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.ctxt.entrySet();
    }

    @Override
    public Object get(Object obj) {
        return this.ctxt.get(obj);
    }

    @Override
    public boolean isEmpty() {
        return this.ctxt.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.ctxt.keySet();
    }

    @Override
    public Object put(String str, Object obj) {
        return this.ctxt.put(str, obj);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.ctxt.putAll(map);
    }

    @Override
    public Object remove(Object obj) {
        return this.ctxt.remove(obj);
    }

    @Override
    public int size() {
        return this.ctxt.size();
    }

    @Override
    public Collection<Object> values() {
        return this.ctxt.values();
    }
}

