/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.Tie;
import com.sun.xml.ws.spi.runtime.Binding;
import com.sun.xml.ws.transport.http.server.EndpointDocInfo;
import com.sun.xml.ws.transport.http.server.EndpointEntityResolver;
import com.sun.xml.ws.transport.http.server.ServerMgr;
import com.sun.xml.ws.transport.http.server.WSHttpHandler;
import com.sun.xml.ws.transport.http.server.WebServiceContextImpl;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpEndpoint {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private String address;
    private HttpContext httpContext;
    private final RuntimeEndpointInfo endpointInfo = new RuntimeEndpointInfo();
    private String primaryWsdl;
    private Executor executor;
    private final Map<String, Object> properties;
    private static final int MAX_THREADS = 5;

    public HttpEndpoint(Object implementor, Binding binding, List<Source> metadata, Map<String, Object> properties, Executor executor) {
        this.endpointInfo.setImplementor(implementor);
        this.endpointInfo.setImplementorClass(implementor.getClass());
        this.endpointInfo.setBinding(binding);
        this.endpointInfo.setUrlPattern("");
        this.endpointInfo.setMetadata(metadata);
        this.properties = properties;
        this.executor = executor;
    }

    private void setServiceName() {
        QName serviceName;
        if (this.properties != null && (serviceName = (QName)this.properties.get("javax.xml.ws.wsdl.service")) != null) {
            this.endpointInfo.setServiceName(serviceName);
        }
    }

    private void setPortName() {
        QName portName;
        if (this.properties != null && (portName = (QName)this.properties.get("javax.xml.ws.wsdl.port")) != null) {
            this.endpointInfo.setPortName(portName);
        }
    }

    private void setDocInfo() throws MalformedURLException {
        List<Source> metadata = this.endpointInfo.getMetadata();
        String wsdlLocation = this.endpointInfo.getWsdlLocation();
        if (wsdlLocation != null) {
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(wsdlLocation);
            if (url == null) {
                throw new ServerRtException("cannot.load.wsdl", wsdlLocation);
            }
            StreamSource source = null;
            try {
                source = new StreamSource(url.openStream());
            }
            catch (IOException ioe) {
                throw new ServerRtException("server.rt.err", new Object[]{ioe});
            }
            this.primaryWsdl = url.toExternalForm();
            source.setSystemId(this.primaryWsdl);
            if (metadata != null) {
                metadata = new ArrayList<Source>();
                this.endpointInfo.setMetadata(metadata);
            }
            metadata.add(source);
        }
        if (metadata != null) {
            HashMap<String, DocInfo> newMetadata = new HashMap<String, DocInfo>();
            Transformer transformer = XmlUtil.newTransformer();
            for (Source source : metadata) {
                URL url;
                ByteArrayBuffer baos = new ByteArrayBuffer();
                try {
                    transformer.transform(source, new StreamResult(baos));
                    baos.close();
                }
                catch (TransformerException te) {
                    throw new ServerRtException("server.rt.err", new Object[]{te});
                }
                String systemId = source.getSystemId();
                try {
                    url = new URL(systemId);
                }
                catch (MalformedURLException me) {
                    logger.severe("Metadata Source's systemId=" + systemId + " is incorrect. Provide a correct one");
                    throw me;
                }
                EndpointDocInfo docInfo = new EndpointDocInfo(url, baos);
                DocInfo old = newMetadata.put(systemId, docInfo);
                if (old == null) continue;
                logger.warning("Duplicate Source objects for systemId=" + systemId + " in metadata");
            }
            this.endpointInfo.setMetadata(newMetadata);
        }
    }

    private void findPrimaryWSDL() throws Exception {
        DocInfo docInfo;
        Map<String, DocInfo> metadata = this.endpointInfo.getDocMetadata();
        if (this.primaryWsdl != null && (docInfo = metadata.get(this.primaryWsdl)).getService() == null) {
            throw new ServerRtException("not.primary.wsdl", this.primaryWsdl);
        }
        if (metadata != null) {
            boolean concreteWsdl = false;
            boolean abstractWsdl = false;
            for (Map.Entry<String, DocInfo> entry : metadata.entrySet()) {
                DocInfo docInfo2 = entry.getValue();
                if (docInfo2.getService() != null) {
                    if (!concreteWsdl) {
                        concreteWsdl = true;
                    } else {
                        throw new ServerRtException("duplicate.primary.wsdl", entry.getKey());
                    }
                }
                if (!docInfo2.isHavingPortType()) continue;
                if (!abstractWsdl) {
                    abstractWsdl = true;
                    continue;
                }
                throw new ServerRtException("duplicate.abstract.wsdl", entry.getKey());
            }
        }
        if (metadata != null) {
            for (Map.Entry<String, DocInfo> entry : metadata.entrySet()) {
                DocInfo docInfo3 = entry.getValue();
                if (docInfo3.getService() == null) continue;
                URL wsdlUrl = new URL(entry.getKey());
                EndpointEntityResolver resolver = new EndpointEntityResolver(metadata);
                this.endpointInfo.setWsdlInfo(wsdlUrl, resolver);
                docInfo3.setQueryString("wsdl");
                break;
            }
        }
    }

    public void fillEndpointInfo() throws Exception {
        this.setServiceName();
        this.setPortName();
        this.endpointInfo.doServiceNameProcessing();
        this.endpointInfo.doPortNameProcessing();
        this.endpointInfo.doPortTypeNameProcessing();
        this.setDocInfo();
        RuntimeEndpointInfo.fillDocInfo(this.endpointInfo);
        this.findPrimaryWSDL();
    }

    public void generateWSDLDocs() {
        if (this.endpointInfo.needWSDLGeneration()) {
            this.endpointInfo.generateWSDL();
        }
    }

    public void publish(String address) {
        try {
            this.address = address;
            this.httpContext = ServerMgr.getInstance().createContext(address);
            try {
                this.publish(this.httpContext);
            }
            catch (Exception e) {
                ServerMgr.getInstance().removeContext(this.httpContext);
                throw e;
            }
        }
        catch (Exception e) {
            throw new ServerRtException("server.rt.err", new Object[]{e});
        }
    }

    public void publish(Object serverContext) {
        this.httpContext = (HttpContext)serverContext;
        try {
            this.publish(this.httpContext);
        }
        catch (Exception e) {
            throw new ServerRtException("server.rt.err", new Object[]{e});
        }
    }

    public void stop() {
        if (this.address == null) {
            this.httpContext.getServer().removeContext(this.httpContext);
        } else {
            ServerMgr.getInstance().removeContext(this.httpContext);
        }
        this.endpointInfo.endService();
    }

    private void publish(HttpContext context) throws Exception {
        this.endpointInfo.verifyImplementorClass();
        this.fillEndpointInfo();
        this.endpointInfo.init();
        this.generateWSDLDocs();
        RuntimeEndpointInfo.publishWSDLDocs(this.endpointInfo);
        logger.fine("Doc Metadata=" + this.endpointInfo.getDocMetadata());
        WebServiceContextImpl wsContext = new WebServiceContextImpl();
        this.endpointInfo.setWebServiceContext(wsContext);
        this.endpointInfo.injectContext();
        this.endpointInfo.beginService();
        Tie tie = new Tie();
        context.setHandler(new WSHttpHandler(tie, this.endpointInfo, this.executor));
    }
}

