/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.TestAutoregister;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.PGboxbase;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class TestBoxes {
    public static final String[] BOXEN3D = new String[]{"BOX3D(1 2 3,4 5 6)", "BOX3D(1 2,4 5)"};
    public static final String[] BOXEN2D = new String[]{"BOX(1 2,3 4)"};
    public static final int SRID = 4326;
    public static final String SRIDPREFIX = "SRID=4326;";
    public static int failcount = 0;

    public static void test(String string, PGobject pGobject, Connection[] connectionArray, boolean bl) throws SQLException {
        PGobject pGobject2;
        System.out.println("Original:  " + string);
        String string2 = pGobject.toString();
        System.out.println("Parsed:    " + string2);
        if (!string.equals(string2)) {
            System.out.println("--- Recreated Text Rep not equal!");
            ++failcount;
        }
        try {
            pGobject2 = (PGobject)pGobject.getClass().newInstance();
        }
        catch (Exception exception) {
            System.out.println("--- pgjdbc instantiation failed!");
            System.out.println("--- " + exception.getMessage());
            ++failcount;
            return;
        }
        pGobject2.setValue(string2);
        String string3 = pGobject2.toString();
        System.out.println("Re-Parsed: " + string3);
        if (!pGobject2.equals((Object)pGobject)) {
            System.out.println("--- Recreated boxen are not equal!");
            ++failcount;
        } else if (!string3.equals(string)) {
            System.out.println("--- 2nd generation text reps are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        for (int i = 0; i < connectionArray.length; ++i) {
            System.out.println("Testing on connection " + i + ": " + connectionArray[i].getCatalog());
            Statement statement = connectionArray[i].createStatement();
            if (bl && TestAutoregister.getPostgisMajor(statement) < 1) {
                System.out.println("PostGIS version is too old, not testing box2d");
            } else {
                PGobject pGobject3;
                try {
                    pGobject3 = TestBoxes.viaSQL(pGobject, statement);
                    System.out.println("SQLin    : " + pGobject3.toString());
                    if (!pGobject.equals((Object)pGobject3)) {
                        System.out.println("--- Geometries after SQL are not equal!");
                        ++failcount;
                    } else {
                        System.out.println("Eq SQL in: yes");
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    pGobject3 = TestBoxes.viaSQL(pGobject2, statement);
                    System.out.println("SQLout  :  " + pGobject3.toString());
                    if (!pGobject.equals((Object)pGobject3)) {
                        System.out.println("--- reparsed Geometries after SQL are not equal!");
                        ++failcount;
                    } else {
                        System.out.println("Eq SQLout: yes");
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
            }
            statement.close();
        }
        System.out.println("***");
    }

    private static PGobject viaSQL(PGobject pGobject, Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT '" + pGobject.toString() + "'::" + pGobject.getType());
        resultSet.next();
        return (PGobject)resultSet.getObject(1);
    }

    public static Connection connect(String string, String string2, String string3) throws SQLException, ClassNotFoundException {
        Class.forName("org.postgis.DriverWrapper");
        Connection connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    public static void main(String[] stringArray) throws SQLException, ClassNotFoundException {
        PGboxbase pGboxbase;
        int n;
        PGtokenizer pGtokenizer;
        String string = null;
        String string2 = null;
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("offline")) {
            System.out.println("Performing only offline tests");
            pGtokenizer = new PGtokenizer("", ';');
        } else if (stringArray.length == 3) {
            System.out.println("Performing offline and online tests");
            pGtokenizer = new PGtokenizer(stringArray[0], ';');
            string = stringArray[1];
            string2 = stringArray[2];
        } else {
            System.err.println("Usage: java examples/TestParser dburls user pass [tablename]");
            System.err.println("   or: java examples/TestParser offline");
            System.err.println();
            System.err.println("dburls has one or more jdbc urls separated by ; in the following format");
            System.err.println("jdbc:postgresql://HOST:PORT/DATABASENAME");
            System.err.println("tablename is 'jdbc_test' by default.");
            System.exit(1);
            return;
        }
        Connection[] connectionArray = new Connection[pGtokenizer.getSize()];
        for (n = 0; n < pGtokenizer.getSize(); ++n) {
            System.out.println("Creating JDBC connection to " + pGtokenizer.getToken(n));
            connectionArray[n] = TestBoxes.connect(pGtokenizer.getToken(n), string, string2);
        }
        System.out.println("Performing tests...");
        System.out.println("***");
        for (n = 0; n < BOXEN3D.length; ++n) {
            try {
                pGboxbase = new PGbox3d(BOXEN3D[n]);
                TestBoxes.test(BOXEN3D[n], pGboxbase, connectionArray, false);
                continue;
            }
            catch (SQLException sQLException) {
                System.out.println("--- Instantiation of " + BOXEN3D[n] + "failed:");
                System.out.println("--- " + sQLException.getMessage());
                ++failcount;
            }
        }
        for (n = 0; n < BOXEN2D.length; ++n) {
            try {
                pGboxbase = new PGbox2d(BOXEN2D[n]);
                TestBoxes.test(BOXEN2D[n], pGboxbase, connectionArray, true);
                continue;
            }
            catch (SQLException sQLException) {
                System.out.println("--- Instantiation of " + BOXEN2D[n] + "failed:");
                System.out.println("--- " + sQLException.getMessage());
                ++failcount;
            }
        }
        System.out.print("cleaning up...");
        for (n = 0; n < connectionArray.length; ++n) {
            connectionArray[n].close();
        }
        System.out.println("Finished, " + failcount + " tests failed!");
        System.err.println("Finished, " + failcount + " tests failed!");
        System.exit(failcount);
    }
}

