/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import org.postgis.Geometry;
import org.postgis.Point;
import org.postgresql.util.PGtokenizer;

public abstract class ComposedGeom
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final Geometry[] EMPTY = new Geometry[0];
    protected Geometry[] subgeoms = EMPTY;
    boolean nohash = true;
    int hashcode = 0;

    public ComposedGeom(int n) {
        super(n);
    }

    public Geometry getSubGeometry(int n) {
        return this.subgeoms[n];
    }

    public int numGeoms() {
        return this.subgeoms.length;
    }

    protected ComposedGeom(int n, Geometry[] geometryArray) {
        this(n);
        this.subgeoms = geometryArray;
        if (geometryArray.length > 0) {
            this.dimension = geometryArray[0].dimension;
            this.haveMeasure = geometryArray[0].haveMeasure;
        } else {
            this.dimension = 0;
        }
    }

    protected ComposedGeom(int n, String string, boolean bl) throws SQLException {
        super(n);
        string = this.initSRID(string);
        String string2 = this.getTypeString();
        if (string.indexOf(string2) == 0) {
            int n2 = string2.length();
            if (string.charAt(n2) == 'M') {
                ++n2;
                bl = true;
            }
            string = string.substring(n2).trim();
        } else if (string.charAt(0) != '(') {
            throw new SQLException("Error parsing a " + string2 + " out of " + string);
        }
        if (string.equals("(EMPTY)")) {
            return;
        }
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara((String)string), ',');
        int n3 = pGtokenizer.getSize();
        this.subgeoms = this.createSubGeomArray(n3);
        for (int i = 0; i < n3; ++i) {
            this.subgeoms[i] = this.createSubGeomInstance(pGtokenizer.getToken(i), bl);
        }
        this.dimension = this.subgeoms[0].dimension;
        this.haveMeasure = this.subgeoms[0].haveMeasure;
    }

    protected abstract Geometry createSubGeomInstance(String var1, boolean var2) throws SQLException;

    protected abstract Geometry[] createSubGeomArray(int var1);

    protected boolean equalsintern(Geometry geometry) {
        ComposedGeom composedGeom = (ComposedGeom)geometry;
        if (composedGeom.subgeoms == null && this.subgeoms == null) {
            return true;
        }
        if (composedGeom.subgeoms == null || this.subgeoms == null) {
            return false;
        }
        if (composedGeom.subgeoms.length != this.subgeoms.length) {
            return false;
        }
        if (this.subgeoms.length == 0) {
            return true;
        }
        for (int i = 0; i < this.subgeoms.length; ++i) {
            if (composedGeom.subgeoms[i].equalsintern(this.subgeoms[i])) continue;
            return false;
        }
        return true;
    }

    public int numPoints() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.subgeoms.length; ++i) {
            n += this.subgeoms[i].numPoints();
        }
        return n;
    }

    public Point getPoint(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index not allowed");
        }
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        for (int i = 0; i < this.subgeoms.length; ++i) {
            Geometry geometry = this.subgeoms[i];
            int n2 = geometry.numPoints();
            if (n < n2) {
                return geometry.getPoint(n);
            }
            n -= n2;
        }
        throw new ArrayIndexOutOfBoundsException("Index too large!");
    }

    public Point getLastPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[this.subgeoms.length - 1].getLastPoint();
    }

    public Point getFirstPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[0].getFirstPoint();
    }

    public Iterator iterator() {
        return Arrays.asList(this.subgeoms).iterator();
    }

    public boolean isEmpty() {
        return this.subgeoms == null || this.subgeoms.length == 0;
    }

    protected void mediumWKT(StringBuffer stringBuffer) {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            stringBuffer.append(" EMPTY");
        } else {
            stringBuffer.append('(');
            this.innerWKT(stringBuffer);
            stringBuffer.append(')');
        }
    }

    protected void innerWKT(StringBuffer stringBuffer) {
        this.subgeoms[0].mediumWKT(stringBuffer);
        for (int i = 1; i < this.subgeoms.length; ++i) {
            stringBuffer.append(',');
            this.subgeoms[i].mediumWKT(stringBuffer);
        }
    }

    public int hashCode() {
        if (this.nohash) {
            this.hashcode = super.hashCode() ^ this.subgeoms.hashCode();
            this.nohash = false;
        }
        return this.hashcode;
    }

    public boolean checkConsistency() {
        if (super.checkConsistency()) {
            if (this.isEmpty()) {
                return true;
            }
            int n = this.dimension;
            boolean bl = this.haveMeasure;
            int n2 = this.srid;
            for (int i = 0; i < this.subgeoms.length; ++i) {
                Geometry geometry = this.subgeoms[i];
                if (geometry.checkConsistency() && geometry.dimension == n && geometry.haveMeasure == bl && geometry.srid == n2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setSrid(int n) {
        super.setSrid(n);
        for (int i = 0; i < this.subgeoms.length; ++i) {
            this.subgeoms[i].setSrid(n);
        }
    }
}

