/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgis.binary.ByteSetter;
import org.postgis.binary.ValueSetter;

public class BinaryWriter {
    public static ValueSetter valueSetterForEndian(ByteSetter byteSetter, byte by) {
        if (by == 0) {
            return new ValueSetter.XDR(byteSetter);
        }
        if (by == 1) {
            return new ValueSetter.NDR(byteSetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + by);
    }

    public synchronized String writeHexed(Geometry geometry, byte by) {
        int n = this.estimateBytes(geometry);
        ByteSetter.StringByteSetter stringByteSetter = new ByteSetter.StringByteSetter(n);
        this.writeGeometry(geometry, BinaryWriter.valueSetterForEndian(stringByteSetter, by));
        return stringByteSetter.result();
    }

    public synchronized String writeHexed(Geometry geometry) {
        return this.writeHexed(geometry, (byte)1);
    }

    public synchronized byte[] writeBinary(Geometry geometry, byte by) {
        int n = this.estimateBytes(geometry);
        ByteSetter.BinaryByteSetter binaryByteSetter = new ByteSetter.BinaryByteSetter(n);
        this.writeGeometry(geometry, BinaryWriter.valueSetterForEndian(binaryByteSetter, by));
        return binaryByteSetter.result();
    }

    public synchronized byte[] writeBinary(Geometry geometry) {
        return this.writeBinary(geometry, (byte)1);
    }

    protected void writeGeometry(Geometry geometry, ValueSetter valueSetter) {
        valueSetter.setByte(valueSetter.endian);
        int n = geometry.type;
        if (geometry.dimension == 3) {
            n |= Integer.MIN_VALUE;
        }
        if (geometry.haveMeasure) {
            n |= 0x40000000;
        }
        if (geometry.srid != -1) {
            n |= 0x20000000;
        }
        valueSetter.setInt(n);
        if (geometry.srid != -1) {
            valueSetter.setInt(geometry.srid);
        }
        switch (geometry.type) {
            case 1: {
                this.writePoint((Point)geometry, valueSetter);
                break;
            }
            case 2: {
                this.writeLineString((LineString)geometry, valueSetter);
                break;
            }
            case 3: {
                this.writePolygon((Polygon)geometry, valueSetter);
                break;
            }
            case 4: {
                this.writeMultiPoint((MultiPoint)geometry, valueSetter);
                break;
            }
            case 5: {
                this.writeMultiLineString((MultiLineString)geometry, valueSetter);
                break;
            }
            case 6: {
                this.writeMultiPolygon((MultiPolygon)geometry, valueSetter);
                break;
            }
            case 7: {
                this.writeCollection((GeometryCollection)geometry, valueSetter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + geometry.type);
            }
        }
    }

    private void writePoint(Point point, ValueSetter valueSetter) {
        valueSetter.setDouble(point.x);
        valueSetter.setDouble(point.y);
        if (point.dimension == 3) {
            valueSetter.setDouble(point.z);
        }
        if (point.haveMeasure) {
            valueSetter.setDouble(point.m);
        }
    }

    private void writeGeometryArray(Geometry[] geometryArray, ValueSetter valueSetter) {
        for (int i = 0; i < geometryArray.length; ++i) {
            this.writeGeometry(geometryArray[i], valueSetter);
        }
    }

    private void writePointArray(Point[] pointArray, ValueSetter valueSetter) {
        valueSetter.setInt(pointArray.length);
        for (int i = 0; i < pointArray.length; ++i) {
            this.writePoint(pointArray[i], valueSetter);
        }
    }

    private void writeMultiPoint(MultiPoint multiPoint, ValueSetter valueSetter) {
        valueSetter.setInt(multiPoint.numPoints());
        this.writeGeometryArray(multiPoint.getPoints(), valueSetter);
    }

    private void writeLineString(LineString lineString, ValueSetter valueSetter) {
        this.writePointArray(lineString.getPoints(), valueSetter);
    }

    private void writeLinearRing(LinearRing linearRing, ValueSetter valueSetter) {
        this.writePointArray(linearRing.getPoints(), valueSetter);
    }

    private void writePolygon(Polygon polygon, ValueSetter valueSetter) {
        valueSetter.setInt(polygon.numRings());
        for (int i = 0; i < polygon.numRings(); ++i) {
            this.writeLinearRing(polygon.getRing(i), valueSetter);
        }
    }

    private void writeMultiLineString(MultiLineString multiLineString, ValueSetter valueSetter) {
        valueSetter.setInt(multiLineString.numLines());
        this.writeGeometryArray(multiLineString.getLines(), valueSetter);
    }

    private void writeMultiPolygon(MultiPolygon multiPolygon, ValueSetter valueSetter) {
        valueSetter.setInt(multiPolygon.numPolygons());
        this.writeGeometryArray(multiPolygon.getPolygons(), valueSetter);
    }

    private void writeCollection(GeometryCollection geometryCollection, ValueSetter valueSetter) {
        valueSetter.setInt(geometryCollection.numGeoms());
        this.writeGeometryArray(geometryCollection.getGeometries(), valueSetter);
    }

    protected int estimateBytes(Geometry geometry) {
        int n = 0;
        ++n;
        n += 4;
        if (geometry.srid != -1) {
            n += 4;
        }
        switch (geometry.type) {
            case 1: {
                n += this.estimatePoint((Point)geometry);
                break;
            }
            case 2: {
                n += this.estimateLineString((LineString)geometry);
                break;
            }
            case 3: {
                n += this.estimatePolygon((Polygon)geometry);
                break;
            }
            case 4: {
                n += this.estimateMultiPoint((MultiPoint)geometry);
                break;
            }
            case 5: {
                n += this.estimateMultiLineString((MultiLineString)geometry);
                break;
            }
            case 6: {
                n += this.estimateMultiPolygon((MultiPolygon)geometry);
                break;
            }
            case 7: {
                n += this.estimateCollection((GeometryCollection)geometry);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + geometry.type);
            }
        }
        return n;
    }

    private int estimatePoint(Point point) {
        int n = 16;
        if (point.dimension == 3) {
            n += 8;
        }
        if (point.haveMeasure) {
            n += 8;
        }
        return n;
    }

    private int estimateGeometryArray(Geometry[] geometryArray) {
        int n = 0;
        for (int i = 0; i < geometryArray.length; ++i) {
            n += this.estimateBytes(geometryArray[i]);
        }
        return n;
    }

    private int estimatePointArray(Point[] pointArray) {
        int n = 4;
        if (pointArray.length > 0) {
            n += pointArray.length * this.estimatePoint(pointArray[0]);
        }
        return n;
    }

    private int estimateMultiPoint(MultiPoint multiPoint) {
        int n = 4;
        if (multiPoint.numPoints() > 0) {
            n += multiPoint.numPoints() * this.estimateBytes(multiPoint.getFirstPoint());
        }
        return n;
    }

    private int estimateLineString(LineString lineString) {
        return this.estimatePointArray(lineString.getPoints());
    }

    private int estimateLinearRing(LinearRing linearRing) {
        return this.estimatePointArray(linearRing.getPoints());
    }

    private int estimatePolygon(Polygon polygon) {
        int n = 4;
        for (int i = 0; i < polygon.numRings(); ++i) {
            n += this.estimateLinearRing(polygon.getRing(i));
        }
        return n;
    }

    private int estimateMultiLineString(MultiLineString multiLineString) {
        return 4 + this.estimateGeometryArray(multiLineString.getLines());
    }

    private int estimateMultiPolygon(MultiPolygon multiPolygon) {
        return 4 + this.estimateGeometryArray(multiPolygon.getPolygons());
    }

    private int estimateCollection(GeometryCollection geometryCollection) {
        return 4 + this.estimateGeometryArray(geometryCollection.getGeometries());
    }
}

