/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep;

import org.lsmp.djep.djep.DPrintVisitor;
import org.lsmp.djep.djep.DSymbolTable;
import org.lsmp.djep.djep.DVariableFactory;
import org.lsmp.djep.djep.Diff;
import org.lsmp.djep.djep.DiffRulesI;
import org.lsmp.djep.djep.DifferentiationVisitor;
import org.lsmp.djep.djep.diffRules.DivideDiffRule;
import org.lsmp.djep.djep.diffRules.MacroDiffRules;
import org.lsmp.djep.djep.diffRules.MacroFunctionDiffRules;
import org.lsmp.djep.djep.diffRules.MultiplyDiffRule;
import org.lsmp.djep.djep.diffRules.PassThroughDiffRule;
import org.lsmp.djep.djep.diffRules.PowerDiffRule;
import org.lsmp.djep.djep.diffRules.SubtractDiffRule;
import org.lsmp.djep.xjep.MacroFunction;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;

public class DJep
extends XJep {
    protected DifferentiationVisitor dv = new DifferentiationVisitor(this);

    public DJep() {
        this.pv = new DPrintVisitor();
        this.symTab = new DSymbolTable(new DVariableFactory());
        this.addFunction("diff", new Diff());
        this.addDiffRule(new PassThroughDiffRule("+", this.getOperatorSet().getAdd().getPFMC()));
        this.addDiffRule(new SubtractDiffRule("-"));
        this.addDiffRule(new MultiplyDiffRule("*"));
        this.addDiffRule(new DivideDiffRule("/"));
        this.addDiffRule(new PowerDiffRule("^"));
        this.addDiffRule(new PassThroughDiffRule("UMinus", this.getOperatorSet().getUMinus().getPFMC()));
    }

    public Node differentiate(Node node, String string) throws ParseException {
        return this.dv.differentiate(node, string, this);
    }

    protected DJep(DJep dJep) {
        super(dJep);
        this.dv = dJep.dv;
    }

    public XJep newInstance() {
        DJep dJep = new DJep(this);
        return dJep;
    }

    public XJep newInstance(SymbolTable symbolTable) {
        DJep dJep = new DJep(this);
        dJep.symTab = symbolTable;
        return dJep;
    }

    public DifferentiationVisitor getDifferentationVisitor() {
        return this.dv;
    }

    public boolean addStandardDiffRules() {
        try {
            this.addDiffRule(new MacroDiffRules(this, "sin", "cos(x)"));
            this.addDiffRule(new MacroDiffRules(this, "cos", "-sin(x)"));
            this.addDiffRule(new MacroDiffRules(this, "tan", "1/((cos(x))^2)"));
            this.addDiffRule(new MacroDiffRules(this, "sec", "sec(x) * tan(x)"));
            this.addDiffRule(new MacroDiffRules(this, "cosec", "-cosec(x) * cot(x)"));
            this.addDiffRule(new MacroDiffRules(this, "cot", "-(cosec(x))^2"));
            this.addDiffRule(new MacroDiffRules(this, "asin", "1/(sqrt(1-x^2))"));
            this.addDiffRule(new MacroDiffRules(this, "acos", "-1/(sqrt(1-x^2))"));
            this.addDiffRule(new MacroDiffRules(this, "atan", "1/(1+x^2)"));
            this.addDiffRule(new MacroDiffRules(this, "sinh", "cosh(x)"));
            this.addDiffRule(new MacroDiffRules(this, "cosh", "sinh(x)"));
            this.addDiffRule(new MacroDiffRules(this, "tanh", "1-(tanh(x))^2"));
            this.addDiffRule(new MacroDiffRules(this, "asinh", "1/(sqrt(1+x^2))"));
            this.addDiffRule(new MacroDiffRules(this, "acosh", "1/(sqrt(x^2-1))"));
            this.addDiffRule(new MacroDiffRules(this, "atanh", "1/(1-x^2)"));
            this.addDiffRule(new MacroDiffRules(this, "sqrt", "1/(2 (sqrt(x)))"));
            this.addDiffRule(new MacroDiffRules(this, "exp", "exp(x)"));
            this.addDiffRule(new MacroDiffRules(this, "ln", "1/x"));
            this.addDiffRule(new MacroDiffRules(this, "log", this.getNodeFactory().buildOperatorNode(this.getOperatorSet().getDivide(), this.getNodeFactory().buildConstantNode(this.getTreeUtils().getNumber(1.0 / Math.log(10.0))), this.getNodeFactory().buildVariableNode(this.getSymbolTable().makeVarIfNeeded("x")))));
            this.addDiffRule(new MacroDiffRules(this, "abs", "abs(x)/x"));
            this.addDiffRule(new MacroDiffRules(this, "atan2", "-y/(x^2+y^2)", "x/(x^2+y^2)"));
            this.addDiffRule(new MacroDiffRules(this, "mod", "1", "0"));
            this.addDiffRule(new PassThroughDiffRule(this, "sum"));
            this.addDiffRule(new PassThroughDiffRule(this, "re"));
            this.addDiffRule(new PassThroughDiffRule(this, "im"));
            this.addDiffRule(new PassThroughDiffRule(this, "rand"));
            MacroFunction macroFunction = (MacroFunction)this.getFunctionTable().get("macrocomplex");
            if (macroFunction != null) {
                this.addDiffRule(new MacroFunctionDiffRules(this, macroFunction));
            }
            return true;
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            return false;
        }
    }

    public void addDiffRule(DiffRulesI diffRulesI) {
        this.dv.addDiffRule(diffRulesI);
    }
}

