/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep;

import org.lsmp.djep.groupJep.groups.FreeGroup;
import org.lsmp.djep.groupJep.values.Polynomial;
import org.lsmp.djep.xjep.DoNothingVisitor;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

public class PolynomialVisitor
extends DoNothingVisitor {
    private OperatorSet opSet;
    private FreeGroup fg;

    public PolynomialVisitor(JEP jEP) {
        this.opSet = jEP.getOperatorSet();
    }

    public Polynomial calcPolynomial(Node node, FreeGroup freeGroup) throws ParseException {
        this.fg = freeGroup;
        return (Polynomial)node.jjtAccept(this, null);
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        int n = aSTFunNode.jjtGetNumChildren();
        Polynomial[] polynomialArray = new Polynomial[n];
        for (int i = 0; i < n; ++i) {
            polynomialArray[i] = (Polynomial)aSTFunNode.jjtGetChild(i).jjtAccept(this, object);
        }
        Operator operator = aSTFunNode.getOperator();
        if (operator == null) {
            throw new ParseException("Function " + aSTFunNode.getName() + " cannot be converted to a polynomial");
        }
        if (operator == this.opSet.getAdd()) {
            return this.fg.add(polynomialArray[0], polynomialArray[1]);
        }
        if (operator == this.opSet.getSubtract()) {
            return this.fg.sub(polynomialArray[0], polynomialArray[1]);
        }
        if (operator == this.opSet.getMultiply()) {
            return this.fg.mul(polynomialArray[0], polynomialArray[1]);
        }
        throw new ParseException("Operator " + operator.getName() + " not supported");
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        if (this.fg.getSymbol().equals(aSTVarNode.getName())) {
            return this.fg.getTPoly();
        }
        Variable variable = aSTVarNode.getVar();
        if (!variable.hasValidValue()) {
            throw new ParseException("Variable " + variable.getName() + " does not have a valid value");
        }
        return this.fg.valueOf(new Number[]{(Number)variable.getValue()});
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return this.fg.valueOf(new Number[]{(Number)aSTConstant.getValue()});
    }
}

