/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.groups;

import org.lsmp.djep.groupJep.groups.ExtendedFreeGroup;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.lsmp.djep.groupJep.values.AlgebraicExtensionElement;
import org.lsmp.djep.groupJep.values.Polynomial;
import org.nfunk.jep.type.Complex;

public class AlgebraicExtension
extends ExtendedFreeGroup
implements RingI {
    private Polynomial poly;
    private Polynomial poly2;

    public AlgebraicExtension(RingI ringI, Polynomial polynomial) {
        super(ringI, polynomial.getSymbol());
        int n;
        this.poly = polynomial;
        if (this.baseRing != polynomial.getBaseRing()) {
            throw new IllegalArgumentException("The polynomial should be specified over the same base ring");
        }
        if (!this.baseRing.equals(polynomial.getCoeffs()[polynomial.getDegree()], this.baseRing.getONE())) {
            throw new IllegalArgumentException("poly " + polynomial.toString() + " should be monic");
        }
        Number[] numberArray = new Number[polynomial.getDegree()];
        for (n = 0; n < polynomial.getDegree(); ++n) {
            numberArray[n] = this.baseRing.getInverse(polynomial.getCoeffs()[n]);
        }
        this.poly2 = new Polynomial(this.baseRing, polynomial.getSymbol(), numberArray);
        if (polynomial.getDegree() == 2) {
            double d;
            double d2 = polynomial.getCoeffs()[1].doubleValue();
            double d3 = d2 * d2 - 4.0 * (d = polynomial.getCoeffs()[0].doubleValue());
            this.rootVal = d3 < 0.0 ? new Complex(-d2 / 2.0, Math.sqrt(-d3) / 2.0) : new Complex(-d2 / 2.0 + Math.sqrt(d3) / 2.0);
        } else {
            n = 1;
            for (int i = 1; i < polynomial.getDegree(); ++i) {
                if (this.baseRing.equals(polynomial.getCoeffs()[i], this.baseRing.getZERO())) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                double d = polynomial.getCoeffs()[0].doubleValue();
                Complex complex = new Complex(-d);
                this.rootVal = complex.power(1.0 / (double)polynomial.getDegree());
            }
        }
        this.zeroPoly = new AlgebraicExtensionElement(this, new Number[]{this.baseRing.getZERO()});
        this.unitPoly = new AlgebraicExtensionElement(this, new Number[]{this.baseRing.getONE()});
        this.tPoly = new AlgebraicExtensionElement(this, new Number[]{this.baseRing.getZERO(), this.baseRing.getONE()});
    }

    public Number valueOf(Number[] numberArray) {
        return new AlgebraicExtensionElement(this, numberArray);
    }

    public String toString() {
        return this.baseRing.toString() + '[' + this.poly.toString() + ']';
    }

    public Polynomial getPoly() {
        return this.poly;
    }

    public Polynomial getSubsPoly() {
        return this.poly2;
    }
}

