/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.jama;

import Jama.Matrix;
import org.lsmp.djep.jama.Inverse;
import org.lsmp.djep.jama.Rank;
import org.lsmp.djep.jama.Solve;
import org.lsmp.djep.vectorJep.values.MVector;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;

public final class JamaUtil {
    public static Matrix toJama(org.lsmp.djep.vectorJep.values.Matrix matrix) throws ParseException {
        int n = matrix.getNumRows();
        int n2 = matrix.getNumCols();
        Object[][] objectArray = matrix.getEles();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = objectArray[i][j];
                if (!(object instanceof Number)) {
                    throw new ParseException("Only real matricies are supported");
                }
                dArray[i][j] = ((Number)object).doubleValue();
            }
        }
        return new Matrix(dArray);
    }

    public static Matrix toJamaCol(MVector mVector) throws ParseException {
        int n = 1;
        int n2 = mVector.getNumEles();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            Object object = mVector.getEle(i);
            if (!(object instanceof Number)) {
                throw new ParseException("Only real matricies are supported");
            }
            dArray[0][i] = ((Number)object).doubleValue();
        }
        return new Matrix(dArray);
    }

    public static Matrix toJamaRow(MVector mVector) throws ParseException {
        int n = mVector.getNumEles();
        int n2 = 1;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            Object object = mVector.getEle(i);
            if (!(object instanceof Number)) {
                throw new ParseException("Only real matricies are supported");
            }
            dArray[i][0] = ((Number)object).doubleValue();
        }
        return new Matrix(dArray);
    }

    public static org.lsmp.djep.vectorJep.values.Matrix fromJama(Matrix matrix, org.lsmp.djep.vectorJep.values.Matrix matrix2) {
        int n = matrix.getRowDimension();
        int n2 = matrix.getRowDimension();
        double[][] dArray = matrix.getArray();
        Object[][] objectArray = matrix2.getEles();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectArray[i][j] = new Double(dArray[i][j]);
            }
        }
        return matrix2;
    }

    public static org.lsmp.djep.vectorJep.values.Matrix fromJama(Matrix matrix) {
        int n = matrix.getRowDimension();
        int n2 = matrix.getRowDimension();
        org.lsmp.djep.vectorJep.values.Matrix matrix2 = (org.lsmp.djep.vectorJep.values.Matrix)org.lsmp.djep.vectorJep.values.Matrix.getInstance(n, n2);
        double[][] dArray = matrix.getArray();
        Object[][] objectArray = matrix2.getEles();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectArray[i][j] = new Double(dArray[i][j]);
            }
        }
        return matrix2;
    }

    public static void addStandardFunctions(JEP jEP) {
        jEP.addFunction("inverse", new Inverse());
        jEP.addFunction("rank", new Rank());
        jEP.addFunction("solve", new Solve());
    }
}

