/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import java.util.Stack;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixSpecialEvaluationI;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMConstant;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.Comparative;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.SpecialEvaluationI;

public class MatrixEvaluator
implements ParserVisitor,
EvaluatorI {
    private Stack stack = new Stack();
    private MatrixJep mjep;

    public MatrixValueI evaluate(MatrixNodeI matrixNodeI, MatrixJep matrixJep) throws ParseException {
        this.mjep = matrixJep;
        return (MatrixValueI)matrixNodeI.jjtAccept(this, null);
    }

    public Object eval(Node node) throws ParseException {
        MatrixValueI matrixValueI = (MatrixValueI)node.jjtAccept(this, null);
        return matrixValueI.copy();
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        return null;
    }

    public Object visit(ASTStart aSTStart, Object object) {
        return null;
    }

    public Object visit(ASTConstant aSTConstant, Object object) {
        return ((ASTMConstant)aSTConstant).getMValue();
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        MatrixVariableI matrixVariableI = (MatrixVariableI)((Object)aSTVarNode.getVar());
        if (matrixVariableI.hasValidValue()) {
            return matrixVariableI.getMValue();
        }
        if (!matrixVariableI.hasEquation()) {
            throw new ParseException("Tried to evaluate a variable with an invalid value but no equation");
        }
        MatrixValueI matrixValueI = (MatrixValueI)matrixVariableI.getEquation().jjtAccept(this, object);
        matrixVariableI.setMValue(matrixValueI);
        return matrixValueI;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        MatrixNodeI matrixNodeI = (MatrixNodeI)((Object)aSTFunNode);
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI instanceof MatrixSpecialEvaluationI) {
            MatrixSpecialEvaluationI matrixSpecialEvaluationI = (MatrixSpecialEvaluationI)((Object)postfixMathCommandI);
            return matrixSpecialEvaluationI.evaluate(matrixNodeI, this, this.mjep);
        }
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            Object object2 = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, this);
            if (object2 instanceof MatrixValueI) {
                matrixNodeI.getMValue().setEles((MatrixValueI)object2);
            } else {
                matrixNodeI.getMValue().setEle(0, object2);
            }
            return matrixNodeI.getMValue();
        }
        if (postfixMathCommandI instanceof SpecialEvaluationI) {
            throw new ParseException("Encountered an instance of SpecialEvaluationI");
        }
        if (postfixMathCommandI instanceof BinaryOperatorI) {
            BinaryOperatorI binaryOperatorI = (BinaryOperatorI)postfixMathCommandI;
            MatrixValueI matrixValueI = (MatrixValueI)aSTFunNode.jjtGetChild(0).jjtAccept(this, object);
            MatrixValueI matrixValueI2 = (MatrixValueI)aSTFunNode.jjtGetChild(1).jjtAccept(this, object);
            return binaryOperatorI.calcValue(matrixNodeI.getMValue(), matrixValueI, matrixValueI2);
        }
        if (postfixMathCommandI instanceof UnaryOperatorI) {
            UnaryOperatorI unaryOperatorI = (UnaryOperatorI)postfixMathCommandI;
            MatrixValueI matrixValueI = (MatrixValueI)aSTFunNode.jjtGetChild(0).jjtAccept(this, object);
            return unaryOperatorI.calcValue(matrixNodeI.getMValue(), matrixValueI);
        }
        if (postfixMathCommandI instanceof NaryOperatorI) {
            NaryOperatorI naryOperatorI = (NaryOperatorI)postfixMathCommandI;
            MatrixValueI[] matrixValueIArray = new MatrixValueI[aSTFunNode.jjtGetNumChildren()];
            for (int i = 0; i < matrixValueIArray.length; ++i) {
                matrixValueIArray[i] = (MatrixValueI)aSTFunNode.jjtGetChild(i).jjtAccept(this, object);
            }
            return naryOperatorI.calcValue(matrixNodeI.getMValue(), matrixValueIArray);
        }
        if (postfixMathCommandI instanceof Comparative) {
            MatrixValueI matrixValueI = (MatrixValueI)aSTFunNode.jjtGetChild(0).jjtAccept(this, object);
            MatrixValueI matrixValueI3 = (MatrixValueI)aSTFunNode.jjtGetChild(1).jjtAccept(this, object);
            this.stack.push(matrixValueI);
            this.stack.push(matrixValueI3);
            postfixMathCommandI.setCurNumberOfParameters(2);
            postfixMathCommandI.run(this.stack);
            matrixNodeI.getMValue().setEle(0, this.stack.pop());
            return matrixNodeI.getMValue();
        }
        int n = aSTFunNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            MatrixValueI matrixValueI = (MatrixValueI)aSTFunNode.jjtGetChild(i).jjtAccept(this, object);
            if (!matrixValueI.getDim().equals(Dimensions.ONE)) {
                throw new ParseException("Arguments of " + aSTFunNode.getName() + " must be scalers");
            }
            this.stack.push(matrixValueI.getEle(0));
        }
        postfixMathCommandI.setCurNumberOfParameters(n);
        postfixMathCommandI.run(this.stack);
        matrixNodeI.getMValue().setEle(0, this.stack.pop());
        return matrixNodeI.getMValue();
    }
}

