/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.MutiablePolynomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Polynomial
extends AbstractPNode {
    PNodeI[] terms;

    Polynomial(PolynomialCreator polynomialCreator, PNodeI[] pNodeIArray) {
        super(polynomialCreator);
        this.terms = pNodeIArray;
    }

    MutiablePolynomial toMutiablePolynomial() {
        PNodeI[] pNodeIArray = new PNodeI[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            pNodeIArray[i] = this.terms[i];
        }
        return new MutiablePolynomial(this.pc, pNodeIArray);
    }

    public PNodeI add(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof Polynomial) {
            return this.add((Polynomial)pNodeI);
        }
        MutiablePolynomial mutiablePolynomial = this.toMutiablePolynomial();
        mutiablePolynomial.add(pNodeI);
        return mutiablePolynomial.toPNode();
    }

    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof Polynomial) {
            return this.sub((Polynomial)pNodeI);
        }
        MutiablePolynomial mutiablePolynomial = this.toMutiablePolynomial();
        mutiablePolynomial.add(pNodeI.negate());
        return mutiablePolynomial.toPNode();
    }

    public PNodeI add(Polynomial polynomial) throws ParseException {
        MutiablePolynomial mutiablePolynomial = this.toMutiablePolynomial();
        for (int i = 0; i < polynomial.terms.length; ++i) {
            mutiablePolynomial.add(polynomial.terms[i]);
        }
        return mutiablePolynomial.toPNode();
    }

    public PNodeI sub(Polynomial polynomial) throws ParseException {
        MutiablePolynomial mutiablePolynomial = this.toMutiablePolynomial();
        for (int i = 0; i < polynomial.terms.length; ++i) {
            mutiablePolynomial.add(polynomial.terms[i].negate());
        }
        return mutiablePolynomial.toPNode();
    }

    public PNodeI negate() throws ParseException {
        PNodeI[] pNodeIArray = new PNodeI[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            pNodeIArray[i] = this.terms[i].negate();
        }
        return new Polynomial(this.pc, pNodeIArray);
    }

    public PNodeI mul(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            PConstant pConstant = (PConstant)pNodeI;
            if (pConstant.isZero()) {
                return this.pc.zeroConstant;
            }
            if (pConstant.isOne()) {
                return this;
            }
        }
        return super.mul(pNodeI);
    }

    public PNodeI div(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            PConstant pConstant = (PConstant)pNodeI;
            if (pConstant.isZero()) {
                return this.pc.infConstant;
            }
            if (pConstant.isOne()) {
                return this;
            }
            PNodeI[] pNodeIArray = new PNodeI[this.terms.length];
            for (int i = 0; i < this.terms.length; ++i) {
                pNodeIArray[i] = this.terms[i].div(pConstant);
            }
            return new Polynomial(this.pc, pNodeIArray);
        }
        return super.div(pNodeI);
    }

    public boolean equals(PNodeI pNodeI) {
        if (!(pNodeI instanceof Polynomial)) {
            return false;
        }
        Polynomial polynomial = (Polynomial)pNodeI;
        if (this.terms.length != polynomial.terms.length) {
            return false;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].equals(polynomial.terms[i])) continue;
            return false;
        }
        return true;
    }

    public int compareTo(PNodeI pNodeI) {
        if (pNodeI instanceof Polynomial) {
            return this.compareTo((Polynomial)pNodeI);
        }
        int n = this.terms[0].compareTo(pNodeI);
        if (n != 0) {
            return n;
        }
        if (this.terms.length == 1) {
            return 0;
        }
        return 1;
    }

    public int compareTo(Polynomial polynomial) {
        for (int i = 0; i < this.terms.length; ++i) {
            if (i >= polynomial.terms.length) {
                return 1;
            }
            int n = this.terms[i].compareTo(polynomial.terms[i]);
            if (n == 0) continue;
            return n;
        }
        if (this.terms.length < polynomial.terms.length) {
            return -1;
        }
        return 0;
    }

    private boolean isNegative(PNodeI pNodeI) {
        if (pNodeI instanceof PConstant) {
            return ((PConstant)pNodeI).isNegative();
        }
        if (pNodeI instanceof Monomial) {
            return ((Monomial)pNodeI).negativeCoefficient();
        }
        return false;
    }

    public String toString() {
        if (this.terms.length == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0 && !this.isNegative(this.terms[i])) {
                stringBuffer.append('+');
            }
            stringBuffer.append(((Object)this.terms[i]).toString());
        }
        return stringBuffer.toString();
    }

    public Node toNode() throws ParseException {
        if (this.terms.length == 0) {
            return this.pc.nf.buildConstantNode(this.pc.zero);
        }
        Node[] nodeArray = new Node[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            nodeArray[i] = this.terms[i].toNode();
        }
        if (this.terms.length == 1) {
            return nodeArray[0];
        }
        return this.pc.nf.buildOperatorNode(this.pc.os.getAdd(), nodeArray);
    }

    public PNodeI expand() throws ParseException {
        MutiablePolynomial mutiablePolynomial = new MutiablePolynomial(this.pc, new PNodeI[]{this.pc.zeroConstant});
        for (int i = 0; i < this.terms.length; ++i) {
            PNodeI pNodeI = this.terms[i].expand();
            mutiablePolynomial.add(pNodeI);
        }
        return mutiablePolynomial.toPNode();
    }
}

