/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.VList;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommand;

public class VMap
extends PostfixMathCommand
implements NaryOperatorI,
CallbackEvaluationI {
    public VMap() {
        this.numberOfParameters = -1;
    }

    public Dimensions calcDim(Dimensions[] dimensionsArray) throws ParseException {
        return dimensionsArray[2];
    }

    public MatrixValueI calcValue(MatrixValueI matrixValueI, MatrixValueI[] matrixValueIArray) throws ParseException {
        return null;
    }

    public static Variable[] getVars(Node node) throws ParseException {
        Variable[] variableArray = null;
        if (node instanceof ASTFunNode && ((ASTFunNode)node).getPFMC() instanceof VList) {
            int n = node.jjtGetNumChildren();
            variableArray = new Variable[n];
            for (int i = 0; i < n; ++i) {
                Node node2 = node.jjtGetChild(i);
                if (!(node2 instanceof ASTVarNode)) {
                    throw new ParseException("Map: second argument should be list of variables");
                }
                variableArray[i] = ((ASTVarNode)node2).getVar();
            }
        } else if (node instanceof ASTVarNode) {
            variableArray = new Variable[]{((ASTVarNode)node).getVar()};
        } else {
            throw new ParseException("Map: second argument should be a variable or list of variables");
        }
        return variableArray;
    }

    public boolean checkNumberOfParameters(int n) {
        return n >= 3;
    }

    public Object evaluate(Node node, EvaluatorI evaluatorI) throws ParseException {
        int n = node.jjtGetNumChildren();
        if (n < 3) {
            throw new ParseException("Map must have three or more arguments");
        }
        Variable[] variableArray = VMap.getVars(node.jjtGetChild(1));
        if (n != variableArray.length + 2) {
            throw new ParseException("Map: number of arguments should match number of variables + 2");
        }
        MatrixValueI[] matrixValueIArray = new MatrixValueI[n - 2];
        Dimensions dimensions = null;
        for (int i = 0; i < n - 2; ++i) {
            Object object = evaluatorI.eval(node.jjtGetChild(i + 2));
            if (object instanceof MatrixValueI) {
                matrixValueIArray[i] = (MatrixValueI)object;
                if (i == 0) {
                    dimensions = matrixValueIArray[0].getDim();
                    continue;
                }
                if (dimensions.equals(matrixValueIArray[i].getDim())) continue;
                throw new ParseException("Map: dimensions of thrid and subsequent arguments must match");
            }
            throw new ParseException("Map: third and following arguments should be vectos or matricies");
        }
        MatrixValueI matrixValueI = Tensor.getInstance(dimensions);
        for (int i = 0; i < dimensions.numEles(); ++i) {
            for (int j = 0; j < variableArray.length; ++j) {
                variableArray[j].setValue(matrixValueIArray[j].getEle(i));
            }
            Object object = evaluatorI.eval(node.jjtGetChild(0));
            matrixValueI.setEle(i, object);
        }
        return matrixValueI;
    }
}

