/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;

public class Console
extends Applet
implements KeyListener {
    private static final long serialVersionUID = 9035584745289937584L;
    protected JEP j;
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
    protected TextArea ta = null;

    public void init() {
        this.initialise();
        this.setLayout(new BorderLayout(1, 1));
        this.ta = new TextArea("", 10, 80, 0);
        this.ta.setEditable(true);
        this.ta.addKeyListener(this);
        this.add("Center", this.ta);
        this.printIntroText();
        this.print(this.getPrompt());
    }

    public static void main(String[] stringArray) {
        Console console = new Console();
        console.run(stringArray);
    }

    public void run(String[] stringArray) {
        this.initialise();
        if (stringArray.length > 0) {
            for (int i = 1; i < stringArray.length; ++i) {
                this.processCommand(stringArray[i]);
            }
        } else {
            this.inputLoop();
        }
    }

    public void inputLoop() {
        String string = "";
        this.printIntroText();
        this.print(this.getPrompt());
        while ((string = this.getCommand()) != null && this.processCommand(string)) {
            this.print(this.getPrompt());
        }
    }

    public boolean processCommand(String string) {
        if (string.equals("quit") || string.equals("exit")) {
            return false;
        }
        if (string.equals("help")) {
            this.printHelp();
            return true;
        }
        if (string.equals("functions")) {
            this.printFuns();
            return true;
        }
        if (string.equals("operators")) {
            this.printOps();
            return true;
        }
        if (string.equals("variables")) {
            this.printVars();
            return true;
        }
        if (!this.testSpecialCommands(string)) {
            return true;
        }
        try {
            Node node = this.j.parse(string);
            this.processEquation(node);
        }
        catch (Exception exception) {
            return this.handleError(exception);
        }
        return true;
    }

    public void initialise() {
        this.j = new JEP();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
    }

    public void processEquation(Node node) throws ParseException {
        Object object = this.j.evaluate(node);
        this.println(object);
    }

    protected String getCommand() {
        String string = null;
        if (this.br == null) {
            return null;
        }
        try {
            string = this.br.readLine();
            if (string == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            this.println("IOError exiting");
            return null;
        }
        return string;
    }

    public String getPrompt() {
        return "JEP > ";
    }

    public final void printStdHelp() {
        if (this.ta == null) {
            this.println("Type 'quit' or 'exit' to quit, 'help' for help.");
        } else {
            this.println("Type 'help' for help.");
        }
    }

    public void printHelp() {
        this.printStdHelp();
        this.println("'functions' lists defined functions");
        this.println("'operators' lists defined operators");
        this.println("'variables' lists variables and constants");
    }

    public void printIntroText() {
        this.println("JEP Console.");
        this.printStdHelp();
    }

    public void printFuns() {
        FunctionTable functionTable = this.j.getFunctionTable();
        this.println("Known functions:");
        Enumeration enumeration = functionTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.println("\t" + string);
        }
    }

    public void printOps() {
        OperatorSet operatorSet = this.j.getOperatorSet();
        Operator[] operatorArray = operatorSet.getOperators();
        this.println("Known operators:");
        for (int i = 0; i < operatorArray.length; ++i) {
            this.println("\t" + operatorArray[i].toString());
        }
    }

    public void printVars() {
        SymbolTable symbolTable = this.j.getSymbolTable();
        this.println("Variables:");
        Enumeration enumeration = symbolTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = symbolTable.getValue(string);
            this.println("\t" + string + "\t" + object);
        }
    }

    public boolean testSpecialCommands(String string) {
        return true;
    }

    public boolean handleError(Exception exception) {
        if (exception instanceof ParseException) {
            this.println("Parse Error: " + exception.getMessage());
        } else {
            this.println("Error: " + exception.getClass().getName() + " " + exception.getMessage());
        }
        return true;
    }

    public String[] split(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void print(Object object) {
        String string = null;
        string = object == null ? "null" : object.toString();
        if (this.ta != null) {
            this.ta.append(string);
        } else {
            System.out.print(string);
        }
    }

    public void println(Object object) {
        String string = null;
        string = object == null ? "null" : object.toString();
        if (this.ta != null) {
            this.ta.append(string + "\n");
        } else {
            System.out.println(string);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            int n2 = this.ta.getCaretPosition();
            String string = this.ta.getText();
            String string2 = string.substring(0, n2 - 1);
            int n3 = string2.lastIndexOf(10);
            if (n3 > 0) {
                string2 = string2.substring(n3 + 1);
            }
            String string3 = this.getPrompt();
            String string4 = null;
            if (string2.startsWith(string3)) {
                string4 = string2.substring(string3.length());
                this.processCommand(string4);
            }
            this.print(this.getPrompt());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public String getAppletInfo() {
        return "Jep Console applet\nR Morris Mar 2005\nSee http://www.singsurf.org/djep/";
    }
}

