/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.lsmp.djep.djep.DJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DJepApplet
extends Applet
implements ActionListener {
    private static final long serialVersionUID = -2026659445630529741L;
    DJep j;
    TextField inputTF;
    TextField varTF;
    TextField outputTF;
    Button but;

    public void init() {
        this.initialise();
        this.setLayout(new GridLayout(3, 2));
        this.inputTF = new TextField("sin(x^2)", 50);
        this.outputTF = new TextField(50);
        this.outputTF.setEditable(false);
        this.varTF = new TextField("x", 5);
        this.but = new Button("Calculate");
        this.but.addActionListener(this);
        this.inputTF.addActionListener(this);
        Panel panel = new Panel();
        panel.add(new Label("Differentiate:"));
        panel.add(this.inputTF);
        this.add(panel);
        Panel panel2 = new Panel();
        panel2.add(new Label("with respect to:"));
        panel2.add(this.varTF);
        panel2.add(this.but);
        this.add(panel2);
        Panel panel3 = new Panel();
        panel3.add(new Label("Result:"));
        panel3.add(this.outputTF);
        this.add(panel3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.inputTF.getText();
        this.j.parseExpression(string);
        if (this.j.hasError()) {
            this.outputTF.setText(this.j.getErrorInfo());
        } else {
            try {
                Node node = this.j.differentiate(this.j.getTopNode(), this.varTF.getText());
                Node node2 = this.j.simplify(node);
                if (this.j.hasError()) {
                    this.outputTF.setText(this.j.getErrorInfo());
                } else {
                    this.outputTF.setText(this.j.toString(node2));
                }
            }
            catch (ParseException parseException) {
                this.outputTF.setText("Parse Error: " + parseException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.outputTF.setText(illegalArgumentException.getMessage());
            }
            catch (Exception exception) {
                this.outputTF.setText(exception.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        DJepApplet dJepApplet = new DJepApplet();
        dJepApplet.init();
        Frame frame = new Frame("Wallpaper patterns");
        frame.setBounds(0, 0, 200, 200);
        frame.add(dJepApplet);
        frame.show();
    }

    public void initialise() {
        this.j = new DJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
        this.j.addStandardDiffRules();
    }
}

