/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.djep.DJep;
import org.lsmp.djepExamples.XJepConsole;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DJepConsole
extends XJepConsole {
    private static final long serialVersionUID = -5801701990800128777L;

    public void initialise() {
        this.j = new DJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
        ((DJep)this.j).addStandardDiffRules();
    }

    public void printHelp() {
        super.printHelp();
        this.println("'diff(x^2,x)' to differentiate x^2 with respect to x");
        this.println("'verbose on', 'verbose off' switch verbose mode on or off");
    }

    public void printIntroText() {
        this.println("DJep: differentiation in JEP. e.g. diff(x^2,x)");
        this.printStdHelp();
    }

    public String getPrompt() {
        return "DJep > ";
    }

    public void processEquation(Node node) throws ParseException {
        DJep dJep = (DJep)this.j;
        if (this.verbose) {
            this.print("Parsed:\t\t");
            this.println(dJep.toString(node));
        }
        Node node2 = dJep.preprocess(node);
        if (this.verbose) {
            this.print("Processed:\t");
            this.println(dJep.toString(node2));
        }
        Node node3 = dJep.simplify(node2);
        if (this.verbose) {
            this.print("Simplified:\t");
        }
        this.println(dJep.toString(node3));
        if (this.verbose) {
            this.print("Full Brackets, no variable expansion:\n\t\t");
            dJep.getPrintVisitor().setMode(1, true);
            dJep.getPrintVisitor().setMode(16, false);
            this.println(dJep.toString(node3));
            dJep.getPrintVisitor().setMode(16, true);
            dJep.getPrintVisitor().setMode(1, false);
        }
        Object object = dJep.evaluate(node3);
        String string = dJep.getPrintVisitor().formatValue(object);
        this.println("Value:\t\t" + string);
    }

    public static void main(String[] stringArray) {
        DJepConsole dJepConsole = new DJepConsole();
        dJepConsole.run(stringArray);
    }
}

