/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.xjep.PrintVisitor;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DiffExample {
    public static void main(String[] stringArray) {
        DJep dJep = new DJep();
        dJep.addStandardConstants();
        dJep.addStandardFunctions();
        dJep.addComplex();
        dJep.setAllowUndeclared(true);
        dJep.setAllowAssignment(true);
        dJep.setImplicitMul(true);
        dJep.addStandardDiffRules();
        try {
            Node node = dJep.parse("sin(x^2)");
            Node node2 = dJep.differentiate(node, "x");
            dJep.println(node2);
            Node node3 = dJep.simplify(node2);
            dJep.println(node3);
            Node node4 = dJep.parse("diff(cos(x^3),x)");
            Node node5 = dJep.preprocess(node4);
            dJep.println(node5);
            Node node6 = dJep.simplify(node5);
            dJep.println(node6);
            Node node7 = dJep.parse("y=x^5");
            dJep.preprocess(node7);
            Node node8 = dJep.parse("diff(y^2+x,x)");
            Node node9 = dJep.simplify(dJep.preprocess(node8));
            dJep.println(node9);
            PrintVisitor printVisitor = dJep.getPrintVisitor();
            printVisitor.setMode(16, false);
            dJep.println(node9);
            printVisitor.setMode(16, true);
            printVisitor.setMode(32, true);
            dJep.println(node9);
            printVisitor.setMode(32, false);
            dJep.getSymbolTable().setVarValue("x", new Double(5.0));
            System.out.println(dJep.evaluate(node9));
            dJep.evaluate(node7);
            System.out.println(dJep.getSymbolTable().getVar("y").getValue());
            dJep.getSymbolTable().setVarValue("x", new Double(0.0));
            System.out.println(dJep.evaluate(node3));
            Node node10 = dJep.parse("x=3");
            Node node11 = dJep.preprocess(node10);
            System.out.println(dJep.evaluate(node11));
            Node node12 = dJep.parse("y=x^2");
            Node node13 = dJep.preprocess(node12);
            System.out.println(dJep.evaluate(node13));
            Node node14 = dJep.parse("z=diff(y,x)");
            Node node15 = dJep.simplify(dJep.preprocess(node14));
            System.out.println(dJep.evaluate(node15));
            dJep.setVarValue("x", new Double(4.0));
            System.out.println(dJep.evaluate(node13));
            System.out.println(dJep.evaluate(node15));
            System.out.println("z: " + dJep.getVarValue("z").toString());
            dJep.setVarValue("x", new Double(5.0));
            System.out.println("j.setVarValue(\"x\",new Double(5));");
            System.out.println("j.findVarValue(y): " + dJep.calcVarValue("y").toString());
            System.out.println("j.findVarValue(z): " + dJep.calcVarValue("z").toString());
            dJep.getSymbolTable().clearValues();
            dJep.setVarValue("x", new Double(6.0));
            System.out.println("j.setVarValue(\"x\",new Double(6));");
            System.out.println("j.findVarValue(z): " + dJep.calcVarValue("z").toString());
            dJep.getSymbolTable().clearValues();
            dJep.setVarValue("x", new Double(7.0));
            System.out.println(dJep.evaluate(node15));
            System.out.println("z: " + dJep.getVarValue("z").toString());
        }
        catch (ParseException parseException) {
            System.out.println("Error with parsing");
        }
        catch (Exception exception) {
            System.out.println("Error with evaluation");
        }
    }
}

