/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.util.Enumeration;
import java.util.Vector;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class MRpDiffExample {
    MatrixJep mj = new MatrixJep();
    MRpEval mrpe = null;
    MRpCommandList[] allCommands;
    int xref;
    int yref;
    double xmin = -1.0;
    double xmax = 1.0;
    double ymin = 1.0;
    double ymax = 1.0;
    int xsteps = 100;
    int ysteps = 100;
    static long oldTime = 0L;

    public static void main(String[] stringArray) {
        MRpDiffExample.timePrint("\tStart");
        MRpDiffExample mRpDiffExample = new MRpDiffExample();
        MRpDiffExample.timePrint("\tDone init");
        try {
            mRpDiffExample.compile("th=pi*x;phi=pi*y;f=[cos(th) cos(phi),sin(th) cos(phi),sin(phi)];dx=diff(f,x);dy=diff(f,y);dx^dy;");
            MRpDiffExample.timePrint("\tDone parse");
            mRpDiffExample.calcMRPE();
            mRpDiffExample.mrpe.cleanUp();
            MRpDiffExample.timePrint("\tDone mrpe");
        }
        catch (Exception exception) {
            System.out.println(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    public static void timePrint(String string) {
        long l = System.currentTimeMillis();
        long l2 = l - oldTime;
        oldTime = l;
        System.out.println("" + l2 + "\t" + string);
    }

    public MRpDiffExample() {
        this.mj.setAllowAssignment(true);
        this.mj.setAllowUndeclared(true);
        this.mj.setImplicitMul(true);
        this.mj.addComplex();
        this.mj.addStandardConstants();
        this.mj.addStandardFunctions();
        this.mj.addStandardDiffRules();
        this.mrpe = new MRpEval(this.mj);
        this.mj.getPrintVisitor().setMode(16, false);
    }

    public void compile(String string) {
        this.mj.restartParser(string);
        try {
            Object object;
            Node node;
            Node node2;
            Node node3;
            Vector<Node> vector = new Vector<Node>();
            while ((node3 = this.mj.continueParsing()) != null) {
                node2 = this.mj.preprocess(node3);
                node = this.mj.simplify(node2);
                vector.add(node);
            }
            node2 = (Node)vector.get(vector.size() - 1);
            node = this.mj.differentiate(node2, "x");
            Node node4 = this.mj.differentiate(node2, "y");
            Vector vector2 = this.mj.recursiveGetVarsInEquation(node2, new Vector());
            vector2 = this.mj.recursiveGetVarsInEquation(node, vector2);
            vector2 = this.mj.recursiveGetVarsInEquation(node4, vector2);
            Vector<MRpCommandList> vector3 = new Vector<MRpCommandList>();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                object = (MatrixVariableI)enumeration.nextElement();
                if (object.hasEquation()) {
                    Node node5 = object.getEquation();
                    System.out.print("Compiling " + object.getName() + "=");
                    this.mj.println(node5);
                    vector3.add(this.mrpe.compile((MatrixVariableI)object, node5));
                    continue;
                }
                System.out.println("Ignoring " + object.getName());
            }
            System.out.print("Compiling ");
            this.mj.println(node2);
            vector3.add(this.mrpe.compile(node2));
            System.out.print("Compiling ");
            this.mj.println(node);
            vector3.add(this.mrpe.compile(node));
            System.out.print("Compiling ");
            this.mj.println(node4);
            vector3.add(this.mrpe.compile(node4));
            int n = 0;
            this.allCommands = new MRpCommandList[vector3.size()];
            object = vector3.elements();
            while (object.hasMoreElements()) {
                this.allCommands[n] = (MRpCommandList)object.nextElement();
                ++n;
            }
            this.xref = this.mrpe.getVarRef(this.mj.getVar("x"));
            this.yref = this.mrpe.getVarRef(this.mj.getVar("y"));
        }
        catch (ParseException parseException) {
            parseException.getMessage();
        }
    }

    public void calcMRPE() {
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        for (int i = 0; i <= this.xsteps; ++i) {
            double d = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            this.mrpe.setVarValue(this.xref, d);
            for (int j = 0; j <= this.ysteps; ++j) {
                double d2 = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                this.mrpe.setVarValue(this.yref, d2);
                MRpRes mRpRes = null;
                for (int k = 0; k < this.allCommands.length - 3; ++k) {
                    mRpRes = this.mrpe.evaluate(this.allCommands[k]);
                }
                mRpRes = this.mrpe.evaluate(this.allCommands[this.allCommands.length - 3]);
                dArray = (double[])mRpRes.toArray();
                mRpRes = this.mrpe.evaluate(this.allCommands[this.allCommands.length - 2]);
                dArray2 = (double[])mRpRes.toArray();
                mRpRes = this.mrpe.evaluate(this.allCommands[this.allCommands.length - 1]);
                dArray3 = (double[])mRpRes.toArray();
            }
        }
        System.out.println("top [" + (double)dArray[0] + "," + (double)dArray[1] + "," + (double)dArray[2] + "]");
        System.out.println("dx [" + (double)dArray2[0] + "," + (double)dArray2[1] + "," + (double)dArray2[2] + "]");
        System.out.println("dy [" + (double)dArray3[0] + "," + (double)dArray3[1] + "," + (double)dArray3[2] + "]");
    }
}

