/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class MRpExample {
    static MatrixJep mj;
    static MRpEval rpe;

    public static void main(String[] stringArray) {
        mj = new MatrixJep();
        mj.addStandardConstants();
        mj.addStandardFunctions();
        mj.addComplex();
        mj.setAllowUndeclared(true);
        mj.setImplicitMul(true);
        mj.setAllowAssignment(true);
        rpe = new MRpEval(mj);
        MRpExample.doStuff("[1,2,3]");
        MRpExample.doStuff("[1,2,3].[4,5,6]");
        MRpExample.doStuff("[1,2,3]^[4,5,6]");
        MRpExample.doStuff("[1,2,3]+[4,5,6]");
        MRpExample.doStuff("[[1,2],[3,4]]");
        MRpExample.doStuff("[[1,2],[3,4]]*[1,0]");
        MRpExample.doStuff("[1,0]*[[1,2],[3,4]]");
        MRpExample.doStuff("[[1,2],[3,4]]*[[1,2],[3,4]]");
        MRpExample.doStuff("x=[1,2,3]");
        MRpExample.doStuff("x+x");
        MRpExample.doStuff("x . x");
        MRpExample.doStuff("x^x");
        MRpExample.doStuff("y=[[1,2],[3,4]]");
        MRpExample.doStuff("y * y");
    }

    public static void doStuff(String string) {
        try {
            Node node = mj.parse(string);
            Node node2 = mj.preprocess(node);
            Node node3 = mj.simplify(node2);
            MRpCommandList mRpCommandList = rpe.compile(node3);
            MRpRes mRpRes = rpe.evaluate(mRpCommandList);
            mj.print(node);
            System.out.println("\nres " + mRpRes.toString());
            MatrixValueI matrixValueI = mRpRes.toVecMat();
            System.out.println("matrix " + matrixValueI.toString());
            if (mRpRes.getDims().is1D()) {
                double[] dArray = (double[])mRpRes.toArray();
                System.out.print("[");
                for (int i = 0; i < dArray.length; ++i) {
                    System.out.print("" + dArray[i] + " ");
                }
                System.out.println("]");
            } else if (mRpRes.getDims().is2D()) {
                double[][] dArray = (double[][])mRpRes.toArray();
                System.out.print("[");
                for (int i = 0; i < dArray.length; ++i) {
                    System.out.print("[");
                    for (int j = 0; j < dArray[i].length; ++j) {
                        System.out.print("" + dArray[i][j] + " ");
                    }
                    System.out.print("]");
                }
                System.out.println("]");
            }
            System.out.println("Commands");
            System.out.println(mRpCommandList.toString());
        }
        catch (ParseException parseException) {
            System.out.println("Parse error " + parseException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("evaluation error " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

