/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.VectorJep;
import org.nfunk.jep.Node;

public class MRpSpeed {
    static MatrixJep mj;
    static VectorJep vj;
    static int num_itts;

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            num_itts = Integer.parseInt(stringArray[0]);
        }
        System.out.println("VectorJep, MatrixJep, MRPEval Speed comparison");
        System.out.println("Number of iterations: " + num_itts);
        long l = System.currentTimeMillis();
        MRpSpeed.initVec();
        long l2 = System.currentTimeMillis();
        System.out.println("Vec initialise " + (l2 - l));
        MRpSpeed.initMat();
        long l3 = System.currentTimeMillis();
        System.out.println("Mat initialise " + (l3 - l2));
        MRpSpeed.doRawAdd();
        MRpSpeed.doObjAdd();
        MRpSpeed.doRawMult();
        MRpSpeed.doObjMult();
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y");
        MRpSpeed.doAll(new String[0], "y=[[1,2,3],[4,5,6],[7,8,9]]");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "z=y*y");
        MRpSpeed.doAll(new String[0], "[[1,2,3],[4,5,6],[7,8,9]]*[[1,2,3],[4,5,6],[7,8,9]]");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y-y");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y+y");
        MRpSpeed.doAll(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "x*y");
        MRpSpeed.doAll(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*x");
        MRpSpeed.doAll(new String[]{"y=[1,2,3]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[1,2,3]"}, "y . y");
        MRpSpeed.doAll(new String[]{"y=[1,2,3]"}, "y^^y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y*y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y-y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y*y+y");
        MRpSpeed.doAll(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "x*y");
        MRpSpeed.doAll(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "y*x");
        MRpSpeed.doAll(new String[0], "1*2*3+4*5*6+7*8*9");
        MRpSpeed.doAll(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
        MRpSpeed.doAll(new String[]{"y=[1,2,3,4,5]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3,4,5],[6,7,8,9,10],[11,12,13,14,15],[16,17,18,19,20],[21,22,23,24,25]]"}, "y*y");
        MRpSpeed.doAll(new String[]{"x=0.7"}, "cos(x)^2+sin(x)^2");
        for (int i = 2; i <= 6; ++i) {
            StringBuffer stringBuffer = new StringBuffer("y=[");
            int n = 1;
            for (int j = 0; j < i; ++j) {
                if (j > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('[');
                for (int k = 0; k < i; ++k) {
                    if (k > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(n);
                    ++n;
                }
                stringBuffer.append(']');
            }
            stringBuffer.append(']');
            MRpSpeed.doAll(new String[]{stringBuffer.toString()}, "y*y");
        }
    }

    public static void doAll(String[] stringArray, String string) {
        System.out.println("Testing speed for <" + string + "> Where ");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("\t" + stringArray[i]);
        }
        long l = MRpSpeed.doVec(stringArray, string);
        long l2 = MRpSpeed.doMat(stringArray, string);
        long l3 = MRpSpeed.doRpe(stringArray, string);
        if (l2 != 0L && l3 != 0L) {
            System.out.println("v/m " + l / l2 + " v/r " + l / l3 + " m/r " + l2 / l3);
        }
        System.out.println();
    }

    static void initVec() {
        vj = new VectorJep();
        vj.addStandardConstants();
        vj.addStandardFunctions();
        vj.addComplex();
        vj.setAllowUndeclared(true);
        vj.setImplicitMul(true);
        vj.setAllowAssignment(true);
    }

    static long doVec(String[] stringArray, String string) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Node node = vj.parse(stringArray[i]);
                vj.evaluate(node);
            }
            Node node = vj.parse(string);
            long l = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                vj.evaluate(node);
            }
            long l2 = System.currentTimeMillis();
            Object object = vj.evaluate(node);
            System.out.print("Using VectorJep:\t" + (l2 - l));
            System.out.println("\t" + object.toString());
            return l2 - l;
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
            return 0L;
        }
    }

    static void initMat() {
        mj = new MatrixJep();
        mj.addStandardConstants();
        mj.addStandardFunctions();
        mj.addComplex();
        mj.setAllowUndeclared(true);
        mj.setImplicitMul(true);
        mj.setAllowAssignment(true);
    }

    static long doMat(String[] stringArray, String string) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Node node = mj.simplify(mj.preprocess(mj.parse(stringArray[i])));
                mj.evaluate(node);
            }
            Node node = mj.simplify(mj.preprocess(mj.parse(string)));
            long l = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                mj.evaluateRaw(node);
            }
            long l2 = System.currentTimeMillis();
            System.out.print("Using MatrixJep:\t" + (l2 - l));
            Object object = mj.evaluate(node);
            System.out.println("\t" + object.toString());
            return l2 - l;
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
            return 0L;
        }
    }

    static long doRpe(String[] stringArray, String string) {
        try {
            Object object;
            for (int i = 0; i < stringArray.length; ++i) {
                object = mj.simplify(mj.preprocess(mj.parse(stringArray[i])));
                mj.evaluate((Node)object);
            }
            Node node = mj.simplify(mj.preprocess(mj.parse(string)));
            object = new MRpEval(mj);
            MRpCommandList mRpCommandList = ((MRpEval)object).compile(node);
            long l = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                ((MRpEval)object).evaluate(mRpCommandList);
            }
            long l2 = System.currentTimeMillis();
            System.out.print("Using MRpEval:\t\t" + (l2 - l));
            MRpRes mRpRes = ((MRpEval)object).evaluate(mRpCommandList);
            System.out.println("\t" + mRpRes.toString());
            ((MRpEval)object).cleanUp();
            return l2 - l;
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
            exception.printStackTrace();
            return 0L;
        }
    }

    static void doRawAdd() {
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] dArrayArray2 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] dArray = new double[3][3];
        long l = System.currentTimeMillis();
        for (int i = 0; i < num_itts; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    dArray[j][k] = dArrayArray[j][k] + dArrayArray2[j][k];
                }
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("RawAdd:" + (l2 - l) + "\tTime to add two double[3][3] arrays");
    }

    static void doRawMult() {
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] dArrayArray2 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] dArray = new double[3][3];
        long l = System.currentTimeMillis();
        for (int i = 0; i < num_itts; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    dArray[j][k] = dArrayArray[j][0] * dArrayArray2[0][k];
                    for (int i2 = 1; i2 < 3; ++i2) {
                        double[] dArray2 = dArray[j];
                        int n = k;
                        dArray2[n] = dArray2[n] + dArrayArray[j][i2] * dArrayArray2[i2][k];
                    }
                }
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("RawMult:" + (l2 - l) + "\tTime to multiply two double[3][3] arrays");
    }

    static void doObjAdd() {
        Double[][] doubleArrayArray = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] doubleArrayArray2 = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] doubleArray = new Double[3][3];
        long l = System.currentTimeMillis();
        for (int i = 0; i < num_itts; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    doubleArray[j][k] = new Double(doubleArrayArray[j][k] + doubleArrayArray2[j][k]);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("ObjAdd:" + (l2 - l) + "\tTime to add two Double[3][3] arrays");
    }

    static void doObjMult() {
        Double[][] doubleArrayArray = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] doubleArrayArray2 = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] doubleArray = new Double[3][3];
        long l = System.currentTimeMillis();
        for (int i = 0; i < num_itts; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double d = doubleArrayArray[j][0] * doubleArrayArray2[0][k];
                    for (int i2 = 1; i2 < 3; ++i2) {
                        d += doubleArrayArray[j][i2] * doubleArrayArray2[i2][k];
                    }
                    doubleArray[j][k] = new Double(d);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("ObjMult:" + (l2 - l) + "\tTime to multiply two Double[3][3] arrays");
    }

    static {
        num_itts = 100000;
    }
}

