/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.util.Enumeration;
import java.util.Vector;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.VectorJep;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

public class MRpSurfExample {
    MatrixJep mj;
    VectorJep vj = new VectorJep();
    MRpEval mrpe = null;
    MRpCommandList[] allCommands;
    Node[] allEqns;
    Node[] vecEqns;
    MatrixVariableI xVar;
    MatrixVariableI yVar;
    Variable xVVar;
    Variable yVVar;
    int xref;
    int yref;
    double xmin = -1.0;
    double xmax = 1.0;
    double ymin = 1.0;
    double ymax = 1.0;
    int xsteps = 1000;
    int ysteps = 1000;
    static long oldTime = 0L;

    public static void main(String[] stringArray) {
        MRpSurfExample.timePrint("\tStart");
        MRpSurfExample mRpSurfExample = new MRpSurfExample();
        MRpSurfExample.timePrint("\tDone init");
        try {
            mRpSurfExample.equationChanged("th=pi*x;phi=pi*y;f=[cos(th) cos(phi),sin(th) cos(phi),sin(phi)];");
            mRpSurfExample.vecEquationChanged(new String[]{"th=pi*x;", "phi=pi*y;", "[cos(th) cos(phi),sin(th) cos(phi),sin(phi)];"});
            MRpSurfExample.timePrint("\tDone parse");
            mRpSurfExample.calcMRPE();
            mRpSurfExample.mrpe.cleanUp();
            MRpSurfExample.timePrint("\tDone mrpe");
            mRpSurfExample.calcMJ();
            MRpSurfExample.timePrint("\tDone MJ");
            mRpSurfExample.calcVJ();
            MRpSurfExample.timePrint("\tDone VJ");
        }
        catch (Exception exception) {
            System.out.println(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    public static void timePrint(String string) {
        long l = System.currentTimeMillis();
        long l2 = l - oldTime;
        oldTime = l;
        System.out.println("" + l2 + "\t" + string);
    }

    public MRpSurfExample() {
        this.vj.setAllowAssignment(true);
        this.vj.setAllowUndeclared(true);
        this.vj.setImplicitMul(true);
        this.vj.addComplex();
        this.vj.addStandardConstants();
        this.vj.addStandardFunctions();
        this.mj = new MatrixJep();
        this.mj.setAllowAssignment(true);
        this.mj.setAllowUndeclared(true);
        this.mj.setImplicitMul(true);
        this.mj.addComplex();
        this.mj.addStandardConstants();
        this.mj.addStandardFunctions();
        this.mj.addStandardDiffRules();
        this.mrpe = new MRpEval(this.mj);
    }

    public void equationChanged(String string) {
        this.mj.restartParser(string);
        try {
            Enumeration enumeration;
            Node node;
            Vector vector = new Vector();
            Vector<Node> vector2 = new Vector<Node>();
            while ((node = this.mj.continueParsing()) != null) {
                Node node2 = this.mj.preprocess(node);
                enumeration = this.mrpe.compile(node2);
                vector.add(enumeration);
                vector2.add(node2);
            }
            int n = 0;
            this.allCommands = new MRpCommandList[vector.size()];
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allCommands[n] = (MRpCommandList)enumeration.nextElement();
                ++n;
            }
            n = 0;
            this.allEqns = new Node[vector2.size()];
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                this.allEqns[n] = (Node)enumeration.nextElement();
                ++n;
            }
            this.xVar = (MatrixVariableI)((Object)this.mj.getVar("x"));
            this.yVar = (MatrixVariableI)((Object)this.mj.getVar("y"));
            this.xref = this.mrpe.getVarRef(this.xVar);
            this.yref = this.mrpe.getVarRef(this.yVar);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
        }
    }

    public void vecEquationChanged(String[] stringArray) {
        try {
            this.vecEqns = new Node[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Node node;
                this.vecEqns[i] = node = this.vj.parse(stringArray[i]);
            }
            this.xVVar = this.vj.getVar("x");
            this.yVVar = this.vj.getVar("y");
        }
        catch (ParseException parseException) {
            parseException.getMessage();
        }
    }

    public void calcMRPE() {
        double[] dArray = null;
        for (int i = 0; i <= this.xsteps; ++i) {
            double d = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            this.mrpe.setVarValue(this.xref, d);
            for (int j = 0; j <= this.ysteps; ++j) {
                double d2 = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                this.mrpe.setVarValue(this.yref, d2);
                MRpRes mRpRes = null;
                for (int k = 0; k < this.allCommands.length; ++k) {
                    mRpRes = this.mrpe.evaluate(this.allCommands[k]);
                }
                dArray = (double[])mRpRes.toArray();
            }
        }
        System.out.println("res " + (double)dArray[0] + "," + (double)dArray[1] + "," + (double)dArray[2]);
    }

    public void calcMJ() throws ParseException {
        Object[] objectArray = null;
        Scaler scaler = (Scaler)this.xVar.getMValue();
        Scaler scaler2 = (Scaler)this.yVar.getMValue();
        this.xVar.setValidValue(true);
        this.yVar.setValidValue(true);
        for (int i = 0; i <= this.xsteps; ++i) {
            double d = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            scaler.setEle(0, new Double(d));
            for (int j = 0; j <= this.ysteps; ++j) {
                double d2 = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                scaler2.setEle(0, new Double(d2));
                Object object = null;
                for (int k = 0; k < this.allEqns.length; ++k) {
                    object = this.mj.evaluate(this.allEqns[k]);
                }
                objectArray = ((MVector)object).getEles();
            }
        }
        System.out.println("res " + objectArray[0] + "," + objectArray[1] + "," + objectArray[2]);
    }

    public void calcVJ() throws ParseException, Exception {
        Object[] objectArray = null;
        for (int i = 0; i <= this.xsteps; ++i) {
            double d = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            this.xVVar.setValue(new Double(d));
            for (int j = 0; j <= this.ysteps; ++j) {
                double d2 = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                this.yVVar.setValue(new Double(d2));
                Object object = null;
                for (int k = 0; k < this.vecEqns.length; ++k) {
                    object = this.vj.evaluate(this.vecEqns[k]);
                }
                objectArray = ((MVector)object).getEles();
            }
        }
        System.out.println("res " + objectArray[0] + "," + objectArray[1] + "," + objectArray[2]);
    }
}

