/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djepExamples.DJepConsole;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class MatrixConsole
extends DJepConsole {
    private static final long serialVersionUID = -4768856862892634425L;

    public static void main(String[] stringArray) {
        MatrixConsole matrixConsole = new MatrixConsole();
        matrixConsole.run(stringArray);
    }

    public String getPrompt() {
        return "MatrixJep > ";
    }

    public void initialise() {
        this.j = new MatrixJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        this.j.setAllowAssignment(true);
        ((MatrixJep)this.j).addStandardDiffRules();
    }

    public void printHelp() {
        super.printHelp();
        this.println("Dot product: [1,2,3].[4,5,6]");
        this.println("Cross product: [1,2,3]^[4,5,6]");
        this.println("Matrix Multiplication: [[1,2],[3,4]]*[[1,2],[3,4]]");
    }

    public void printIntroText() {
        this.println("MatrixJep: advanced vector and matrix handling");
        super.printStdHelp();
    }

    public void processEquation(Node node) throws ParseException {
        MatrixJep matrixJep = (MatrixJep)this.j;
        if (this.verbose) {
            this.print("Parsed:\t\t");
            this.println(matrixJep.toString(node));
        }
        Node node2 = matrixJep.preprocess(node);
        if (this.verbose) {
            this.print("Processed:\t");
            this.println(matrixJep.toString(node2));
        }
        Node node3 = matrixJep.simplify(node2);
        if (this.verbose) {
            this.print("Simplified:\t");
        }
        this.println(matrixJep.toString(node3));
        Object object = matrixJep.evaluate(node3);
        String string = matrixJep.getPrintVisitor().formatValue(object);
        this.println("Value:\t\t" + string);
    }
}

