/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class MatrixExample {
    static MatrixJep j;

    public static void main(String[] stringArray) {
        j = new MatrixJep();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setImplicitMul(true);
        j.setAllowAssignment(true);
        MatrixExample.doStuff("[1,2,3]");
        MatrixExample.doStuff("[1,2,3].[4,5,6]");
        MatrixExample.doStuff("[1,2,3]^[4,5,6]");
        MatrixExample.doStuff("[1,2,3]+[4,5,6]");
        MatrixExample.doStuff("[[1,2],[3,4]]");
        MatrixExample.doStuff("[[1,2],[3,4]]*[1,0]");
        MatrixExample.doStuff("[1,0]*[[1,2],[3,4]]");
        MatrixExample.doStuff("[[1,2],[3,4]]*[[1,2],[3,4]]");
        MatrixExample.doStuff("x=[1,2,3]");
        MatrixExample.doStuff("x+x");
        MatrixExample.doStuff("x . x");
        MatrixExample.doStuff("x^x");
        MatrixExample.doStuff("y=[[1,2],[3,4]]");
        MatrixExample.doStuff("y * y");
        MatrixExample.doStuff("ele(x,2)");
        MatrixExample.doStuff("ele(y,[1,2])");
        MatrixExample.doStuff("x=2");
        MatrixExample.doStuff("y=[x^3,x^2,x]");
        MatrixExample.doStuff("z=diff(y,x)");
        MatrixExample.doStuff("diff([x^3,x^2,x],x)");
        System.out.println("dim(z) " + ((MatrixVariableI)((Object)j.getVar("z"))).getDimensions());
    }

    public static void doStuff(String string) {
        try {
            Node node = j.parse(string);
            Node node2 = j.preprocess(node);
            Node node3 = j.simplify(node2);
            Object object = j.evaluate(node3);
            j.print(node3);
            System.out.print("\t dim " + ((MatrixNodeI)node3).getDim());
            System.out.println("\tvalue " + object.toString());
        }
        catch (ParseException parseException) {
            System.out.println("Parse error " + parseException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("evaluation error " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

