/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.vectorJep.VectorJep;
import org.nfunk.jep.Node;

public class MatrixSpeed {
    static MatrixJep mj;
    static VectorJep vj;
    static int num_itts;

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        MatrixSpeed.initVec();
        long l2 = System.currentTimeMillis();
        System.out.println("Vec initialise " + (l2 - l));
        MatrixSpeed.initMat();
        long l3 = System.currentTimeMillis();
        System.out.println("Mat initialise " + (l3 - l2));
        MatrixSpeed.doBoth("y=[[1,2,3],[3,4,5],[6,7,8]]", "y*y");
        MatrixSpeed.doBoth("y=[[1,2,3],[3,4,5],[6,7,8]]", "y+y");
        MatrixSpeed.doBoth("y=[[1,2,3],[3,4,5],[6,7,8]]", "y-y");
        MatrixSpeed.doBoth("y=[[1,2,3],[3,4,5],[6,7,8]]", "y*y+y");
        MatrixSpeed.doBoth("y=[1,2,3]", "y+y");
        MatrixSpeed.doBoth("y=[1,2,3]", "y . y");
        MatrixSpeed.doBoth("y=[1,2,3]", "y^^y");
    }

    public static void doBoth(String string, String string2) {
        System.out.println("Testing speed for <" + string + "> and <" + string2 + ">");
        MatrixSpeed.doVec(string, string2);
        MatrixSpeed.doMat(string, string2);
    }

    static void initVec() {
        vj = new VectorJep();
        vj.addStandardConstants();
        vj.addStandardFunctions();
        vj.addComplex();
        vj.setAllowUndeclared(true);
        vj.setImplicitMul(true);
        vj.setAllowAssignment(true);
    }

    static void doVec(String string, String string2) {
        try {
            Node node = vj.parse(string);
            vj.evaluate(node);
            Node node2 = vj.parse(string2);
            long l = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                vj.evaluate(node2);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Using VectorJep :" + (l2 - l));
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
        }
    }

    static void initMat() {
        mj = new MatrixJep();
        mj.addStandardConstants();
        mj.addStandardFunctions();
        mj.addComplex();
        mj.setAllowUndeclared(true);
        mj.setImplicitMul(true);
        mj.setAllowAssignment(true);
    }

    static void doMat(String string, String string2) {
        try {
            Node node = mj.simplify(mj.preprocess(mj.parse(string)));
            mj.evaluate(node);
            Node node2 = mj.simplify(mj.preprocess(mj.parse(string2)));
            long l = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                mj.evaluateRaw(node2);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Using MatrixJep :" + (l2 - l));
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
        }
    }

    static {
        num_itts = 100000;
    }
}

