/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.rpe.RpCommand;
import org.lsmp.djep.rpe.RpCommandList;
import org.lsmp.djep.rpe.RpEval;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

public class RpExample {
    static JEP j;

    public static void main(String[] stringArray) {
        j = new JEP();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setImplicitMul(true);
        j.setAllowAssignment(true);
        RpExample.doStuff("1*2*3+4*5*6+7*8*9");
        RpExample.doAll(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9", "x1*x2*x3+x4*x5*x6+x7*x8*x9"});
        RpExample.doAll(new String[]{"x=0.7", "cos(x)^2+sin(x)^2"});
    }

    public static void extendedPrint(RpCommandList rpCommandList) throws ParseException {
        int n = rpCommandList.getNumCommands();
        for (int i = 0; i < n; ++i) {
            RpCommand rpCommand = rpCommandList.getCommand(i);
            int n2 = rpCommand.getType();
            int n3 = rpCommand.getRef();
            if (n2 == 0) {
                double d = rpCommand.getConstantValue();
                System.out.println("Constant\t" + d + "\t" + n3);
                continue;
            }
            if (n2 == 1) {
                Variable variable = rpCommand.getVariable();
                System.out.println("Variable\t" + variable.toString() + "\t" + n3);
                continue;
            }
            if (n2 == 23) {
                String string = rpCommand.getFunction();
                System.out.println("Function\t" + string + "\t" + n3);
                continue;
            }
            System.out.println("Operator\t" + rpCommand.toString());
        }
    }

    public static void doStuff(String string) {
        try {
            Node node = j.parse(string);
            RpEval rpEval = new RpEval(j);
            RpCommandList rpCommandList = rpEval.compile(node);
            double d = rpEval.evaluate(rpCommandList);
            System.out.println("Expression:\t" + string + "\nresult\t" + d);
            System.out.println("Commands:");
            RpExample.extendedPrint(rpCommandList);
            System.out.println();
        }
        catch (ParseException parseException) {
            System.out.println("Parse error " + parseException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("evaluation error " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void doAll(String[] stringArray) {
        try {
            RpEval rpEval = new RpEval(j);
            for (int i = 0; i < stringArray.length; ++i) {
                Node node = j.parse(stringArray[i]);
                RpCommandList rpCommandList = rpEval.compile(node);
                double d = rpEval.evaluate(rpCommandList);
                System.out.println("Expression " + i + ":\t" + stringArray[i] + "\nresult\t" + d);
                System.out.println("Commands:");
                RpExample.extendedPrint(rpCommandList);
                System.out.println();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Parse error " + parseException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("evaluation error " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

