/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.rpe.RpCommandList;
import org.lsmp.djep.rpe.RpEval;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;

public class RpSpeed {
    static JEP j;
    static int num_itts;

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        RpSpeed.initJep();
        long l2 = System.currentTimeMillis();
        System.out.println("Jep initialise " + (l2 - l));
        RpSpeed.doAll(new String[0], "1*2*3+4*5*6+7*8*9");
        RpSpeed.doAll(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
        RpSpeed.doAll(new String[]{"x=0.7"}, "cos(x)^2+sin(x)^2");
    }

    public static void doAll(String[] stringArray, String string) {
        System.out.print("Testing speed for <");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.print(stringArray[i] + ",");
        }
        System.out.println("> and <" + string + ">");
        RpSpeed.doJep(stringArray, string);
        RpSpeed.doRpe(stringArray, string);
        System.out.println();
    }

    static void initJep() {
        j = new JEP();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setImplicitMul(true);
        j.setAllowAssignment(true);
    }

    static void doJep(String[] stringArray, String string) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Node node = j.parse(stringArray[i]);
                j.evaluate(node);
            }
            Node node = j.parse(string);
            long l = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                j.evaluate(node);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Using Jep:\t" + (l2 - l));
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
        }
    }

    static void doRpe(String[] stringArray, String string) {
        try {
            Object object;
            for (int i = 0; i < stringArray.length; ++i) {
                object = j.parse(stringArray[i]);
                j.evaluate((Node)object);
            }
            Node node = j.parse(string);
            object = new RpEval(j);
            RpCommandList rpCommandList = ((RpEval)object).compile(node);
            long l = System.currentTimeMillis();
            for (int i = 0; i < num_itts; ++i) {
                ((RpEval)object).evaluate(rpCommandList);
            }
            long l2 = System.currentTimeMillis();
            System.out.print("Using RpEval2:\t\t" + (l2 - l));
            double d = ((RpEval)object).evaluate(rpCommandList);
            System.out.println("\t" + d);
            ((RpEval)object).cleanUp();
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    static {
        num_itts = 100000;
    }
}

