/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.text.NumberFormat;
import java.util.Enumeration;
import org.lsmp.djep.xjep.PrintVisitor;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.lsmp.djep.xjep.XVariable;
import org.lsmp.djepExamples.Console;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;

public class XJepConsole
extends Console {
    private static final long serialVersionUID = -3239922790774093668L;
    protected NumberFormat format = null;
    protected boolean verbose = false;

    public static void main(String[] stringArray) {
        XJepConsole xJepConsole = new XJepConsole();
        xJepConsole.run(stringArray);
    }

    public String getPrompt() {
        return "XJep > ";
    }

    public void initialise() {
        this.j = new XJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
    }

    public void printHelp() {
        super.printHelp();
        this.println("'setMaxLen 80'\tensures all lines and < 80 chars");
        this.println("'setDP 3'\tonly prints 3 decimal places");
        this.println("'setFullBrackets true'\tprints equations with full bracketing");
        this.println("'setComplexI true'\tprint complex numbers in form x+iy");
        this.println("'invalidate'\tmarks all variables as invalid, forcing reevaluation");
        this.println("eg 'x=5','y=2*x' gives value 10, 'invalidate', 'x=6', 'y' gives value 12");
    }

    public void printIntroText() {
        this.println("XJep Console");
        super.printStdHelp();
    }

    public void printOps() {
        int n;
        this.println("Known operators");
        Operator[] operatorArray = this.j.getOperatorSet().getOperators();
        int n2 = -1;
        for (n = 0; n < operatorArray.length; ++n) {
            if (((XOperator)operatorArray[n]).getPrecedence() <= n2) continue;
            n2 = ((XOperator)operatorArray[n]).getPrecedence();
        }
        for (n = -1; n <= n2; ++n) {
            for (int i = 0; i < operatorArray.length; ++i) {
                if (((XOperator)operatorArray[i]).getPrecedence() != n) continue;
                this.println(((XOperator)operatorArray[i]).toFullString());
            }
        }
    }

    public boolean testSpecialCommands(String string) {
        if (!super.testSpecialCommands(string)) {
            return false;
        }
        XJep xJep = (XJep)this.j;
        if (string.equals("invalidate")) {
            this.resetVars();
            return false;
        }
        if (string.startsWith("setMaxLen")) {
            String[] stringArray = this.split(string);
            int n = Integer.parseInt(stringArray[1]);
            xJep.getPrintVisitor().setMaxLen(n);
            return false;
        }
        if (string.startsWith("setDp")) {
            String[] stringArray = this.split(string);
            int n = Integer.parseInt(stringArray[1]);
            this.format = NumberFormat.getInstance();
            xJep.getPrintVisitor().setNumberFormat(this.format);
            this.format.setMaximumFractionDigits(n);
            this.format.setMinimumFractionDigits(n);
            return false;
        }
        if (string.startsWith("setFullBrackets")) {
            String[] stringArray = this.split(string);
            if (stringArray.length > 1 && stringArray[1].equals("true")) {
                xJep.getPrintVisitor().setMode(1, true);
            } else {
                xJep.getPrintVisitor().setMode(1, true);
            }
            return false;
        }
        if (string.startsWith("setComplexI")) {
            String[] stringArray = this.split(string);
            if (stringArray.length > 1 && stringArray[1].equals("true")) {
                xJep.getPrintVisitor().setMode(2, true);
            } else {
                xJep.getPrintVisitor().setMode(2, true);
            }
            return false;
        }
        if (string.startsWith("verbose")) {
            String[] stringArray = this.split(string);
            if (stringArray.length < 2) {
                this.println("verbose should be on or off");
            } else if (stringArray[1].equals("on")) {
                this.verbose = true;
            } else if (stringArray[1].equals("off")) {
                this.verbose = true;
            } else {
                this.println("verbose should be on or off");
            }
            return false;
        }
        return true;
    }

    public void processEquation(Node node) throws ParseException {
        Node node2;
        XJep xJep = (XJep)this.j;
        if (xJep.getPrintVisitor().getMode(1)) {
            this.print("Node:\t");
            xJep.println(node);
        }
        if ((node2 = xJep.preprocess(node)) == null) {
            return;
        }
        if (xJep.getPrintVisitor().getMode(1)) {
            this.print("Processed:\t");
            xJep.println(node2);
        }
        Node node3 = xJep.simplify(node2);
        this.print("Simplified:\t");
        this.println(xJep.toString(node3));
        Object object = xJep.evaluate(node3);
        String string = xJep.getPrintVisitor().formatValue(object);
        this.println("Value:\t\t" + string);
    }

    public void printVars() {
        PrintVisitor printVisitor = ((XJep)this.j).getPrintVisitor();
        SymbolTable symbolTable = this.j.getSymbolTable();
        printVisitor.setMode(16, !this.verbose);
        this.println("Variables:");
        Enumeration enumeration = symbolTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            XVariable xVariable = (XVariable)symbolTable.getVar(string);
            this.println("\t" + xVariable.toString(printVisitor));
        }
        printVisitor.setMode(16, true);
    }

    public void resetVars() {
        this.j.getSymbolTable().clearValues();
    }
}

