/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DSymbolTable;
import org.lsmp.djepJUnit.XJepTest;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DJepTest
extends XJepTest {
    static /* synthetic */ Class class$org$lsmp$djepJUnit$DJepTest;

    public DJepTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$DJepTest == null ? (class$org$lsmp$djepJUnit$DJepTest = DJepTest.class$("org.lsmp.djepJUnit.DJepTest")) : class$org$lsmp$djepJUnit$DJepTest);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$DJepTest == null ? (class$org$lsmp$djepJUnit$DJepTest = DJepTest.class$("org.lsmp.djepJUnit.DJepTest")) : class$org$lsmp$djepJUnit$DJepTest);
        testSuite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new DJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        ((DJep)this.j).addStandardDiffRules();
    }

    public void testDiff() throws ParseException {
        System.out.println("\nTesting assignment");
        this.simplifyTest("diff(x^2,x)", "2 x");
        this.simplifyTest("diff(x^3,x)", "3 x^2");
        this.simplifyTest("diff(x,x)", "1");
        this.simplifyTest("diff(1,x)", "0");
        this.simplifyTest("diff(x^2+x+1,x)", "2 x+1");
        this.simplifyTest("diff((x+x^2)*(x+x^3),x)", "(1+2*x)*(x+x^3)+(x+x^2)*(1+3*x^2)");
        this.simplifyTest("diff((x+x^2)/(x+x^3),x)", "((1+2*x)*(x+x^3)-(x+x^2)*(1+3*x^2))/((x+x^3)*(x+x^3))");
        this.simplifyTest("diff(y^x,x)", "y^x*ln(y)");
        this.simplifyTest("diff(e^x,x)", "e^x*ln(e)");
        this.simplifyTest("diff(sin(x),x)", "cos(x)");
        this.simplifyTest("diff((x+1)^2,x)", "2+2*x");
        this.simplifyTest("diff((x+y)^2,x)", "2*(x+y)");
        this.simplifyTest("diff((x+x^2)^3,x)", "3*(x+x^2)^2*(1+2*x)");
        this.simplifyTest("diff(sin(x+1),x)", "cos(x+1)");
        this.simplifyTest("diff(sin(x+x^2),x)", "cos(x+x^2)*(1+2*x)");
        this.simplifyTest("diff(cos(x),x)", "-sin(x)");
        this.simplifyTest("diff(tan(x),x)", "1/((cos(x))^2)");
        this.simplifyTest("diff(sec(x),x)", "sec(x)*tan(x)");
        this.simplifyTest("diff(cosec(x),x)", "-cosec(x) * cot(x)");
        this.simplifyTest("diff(cot(x),x)", "-(cosec(x))^2");
        this.simplifyTest("diff(sec(x),x)", "sec(x) * tan(x)");
        this.simplifyTest("diff(cosec(x),x)", "-cosec(x) * cot(x)");
        this.simplifyTest("diff(cot(x),x)", "-(cosec(x))^2");
        this.simplifyTest("diff(asin(x),x)", "1/(sqrt(1-x^2))");
        this.simplifyTest("diff(acos(x),x)", "-1/(sqrt(1-x^2))");
        this.simplifyTest("diff(atan(x),x)", "1/(1+x^2)");
        this.simplifyTest("diff(sinh(x),x)", "cosh(x)");
        this.simplifyTest("diff(cosh(x),x)", "sinh(x)");
        this.simplifyTest("diff(tanh(x),x)", "1-(tanh(x))^2");
        this.simplifyTest("diff(asinh(x),x)", "1/(sqrt(1+x^2))");
        this.simplifyTest("diff(acosh(x),x)", "1/(sqrt(x^2-1))");
        this.simplifyTest("diff(atanh(x),x)", "1/(1-x^2)");
        this.simplifyTest("diff(sqrt(x),x)", "1/(2 (sqrt(x)))");
        this.simplifyTest("diff(exp(x),x)", "exp(x)");
        this.simplifyTest("diff(ln(x),x)", "1/x");
        this.simplifyTest("diff(log(x),x)", "(1/ln(10)) /x");
        this.simplifyTest("diff(abs(x),x)", "abs(x)/x");
        this.simplifyTest("diff(atan2(y,x),x)", "y/(y^2+x^2)");
        this.simplifyTest("diff(atan2(y,x),y)", "-x/(y^2+x^2)");
        this.simplifyTest("diff(mod(x,y),x)", "1");
        this.simplifyTest("diff(mod(x,y),y)", "0");
        this.simplifyTest("diff(sum(x,x^2,x^3),x)", "sum(1,2 x,3 x^2)");
    }

    public void testAssignDiff() throws Exception {
        System.out.println("\nTesting assignment and diff");
        this.simplifyTestString("y=x^5", "y=x^5.0");
        this.simplifyTestString("z=diff(y,x)", "z=5.0*x^4.0");
        Node node = ((DSymbolTable)this.j.getSymbolTable()).getPartialDeriv("y", new String[]{"x"}).getEquation();
        this.myAssertEquals("dy/dx", ((DJep)this.j).toString(node), "5.0*x^4.0");
        this.simplifyTestString("w=diff(z,x)", "w=20.0*x^3.0");
        Node node2 = ((DSymbolTable)this.j.getSymbolTable()).getPartialDeriv("y", new String[]{"x", "x"}).getEquation();
        this.myAssertEquals("d^2y/dxdx", ((DJep)this.j).toString(node2), "20.0*x^3.0");
        this.valueTest("x=2", 2.0);
        this.valueTest("y", 32.0);
        this.valueTest("z", 80.0);
        this.valueTest("w", 160.0);
        this.simplifyTestString("diff(ln(y),x)", "(1.0/y)*5.0*x^4.0");
    }

    public void testChainedVaraibles() throws Exception {
        this.simplifyTestString("x=5", "x=5.0");
        this.simplifyTestString("y=x", "y=x");
        this.simplifyTestString("z=y", "z=y");
        this.simplifyTestString("w=diff(z,x)", "w=1.0");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

