/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import java.math.BigInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.groupJep.GroupJep;
import org.lsmp.djep.groupJep.PolynomialVisitor;
import org.lsmp.djep.groupJep.groups.AlgebraicExtension;
import org.lsmp.djep.groupJep.groups.ExtendedFreeGroup;
import org.lsmp.djep.groupJep.groups.FreeGroup;
import org.lsmp.djep.groupJep.groups.Integers;
import org.lsmp.djep.groupJep.groups.Quaternions;
import org.lsmp.djep.groupJep.groups.Rationals;
import org.lsmp.djep.groupJep.groups.Reals;
import org.lsmp.djep.groupJep.groups.Zn;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.lsmp.djep.groupJep.values.FreeGroupElement;
import org.lsmp.djep.groupJep.values.HasComplexValueI;
import org.lsmp.djep.groupJep.values.Polynomial;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class GroupJepTest
extends TestCase {
    GroupJep j;
    public static final boolean SHOW_BAD = false;
    static /* synthetic */ Class class$org$lsmp$djepJUnit$GroupJepTest;

    public GroupJepTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$GroupJepTest == null ? (class$org$lsmp$djepJUnit$GroupJepTest = GroupJepTest.class$("org.lsmp.djepJUnit.GroupJepTest")) : class$org$lsmp$djepJUnit$GroupJepTest);
        testSuite.run(new TestResult());
    }

    protected void setUp() {
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$GroupJepTest == null ? (class$org$lsmp$djepJUnit$GroupJepTest = GroupJepTest.class$("org.lsmp.djepJUnit.GroupJepTest")) : class$org$lsmp$djepJUnit$GroupJepTest);
    }

    public void myAssertEquals(String string, String string2, String string3) {
        if (!string3.equals(string2)) {
            System.out.println("Error \"" + string + "\" is \"" + string3 + " should be " + string2 + "\"");
        }
        GroupJepTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)string3);
        System.out.println("Success: Value of \"" + string + "\" is \"" + string3 + "\"");
    }

    public void myAssertEquals(String string, String string2, String string3, String string4) {
        if (!string3.equals(string2)) {
            System.out.println("Error \"" + string + "\" is \"" + string3 + " should be " + string2 + "\"");
        }
        GroupJepTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)string3);
        System.out.println("Success: Value of \"" + string + "\" is \"" + string3 + "\": " + string4);
    }

    public void testGood() {
        GroupJepTest.assertEquals((int)1, (int)1);
    }

    public void valueToStringTest(String string, String string2) throws Exception {
        Node node = this.j.parse(string);
        Object object = this.j.evaluate(node);
        String string3 = object.toString();
        String string4 = "";
        if (object instanceof HasComplexValueI) {
            Complex complex = ((HasComplexValueI)object).getComplexValue();
            string4 = complex.toString();
        }
        this.myAssertEquals(string, string2, string3, string4);
    }

    public void testZ() throws Exception {
        this.j = new GroupJep(new Integers());
        this.valueToStringTest("1*2*3*4*5*6*7*8*9*10*11*12*13*14*15*16*17*18*19*20", "2432902008176640000");
    }

    public void testQ() throws Exception {
        this.j = new GroupJep(new Rationals());
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("(1/2)-(1/3)", "1/6");
    }

    public void testQuartonians() throws Exception {
        this.j = new GroupJep(new Quaternions());
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("i*j", "-k");
    }

    public void testZn() throws Exception {
        this.j = new GroupJep(new Zn(BigInteger.valueOf(5L)));
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("2*3", "1");
        this.valueToStringTest("2*4", "3");
        this.valueToStringTest("3*3", "4");
        this.valueToStringTest("3*4", "2");
        this.valueToStringTest("4*4", "1");
        this.valueToStringTest("2/3", "4");
        this.valueToStringTest("2/4", "3");
        this.valueToStringTest("3/2", "4");
        this.valueToStringTest("3/4", "2");
        this.valueToStringTest("4/2", "2");
        this.valueToStringTest("4/3", "3");
    }

    public void testZroot2() throws Exception {
        Integers integers = new Integers();
        Number[] numberArray = new Number[]{BigInteger.valueOf(-2L), BigInteger.ZERO, BigInteger.ONE};
        Polynomial polynomial = new Polynomial(integers, "rt2", numberArray);
        this.j = new GroupJep(new AlgebraicExtension((RingI)integers, polynomial));
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("rt2*rt2", "2");
        this.valueToStringTest("(rt2+1)*(rt2+1)", "2 rt2+3");
    }

    public void testZ5thRootUnity() throws Exception {
        Integers integers = new Integers();
        Number[] numberArray = new Number[]{BigInteger.valueOf(-1L), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ONE};
        Polynomial polynomial = new Polynomial(integers, "t", numberArray);
        this.j = new GroupJep(new AlgebraicExtension((RingI)integers, polynomial));
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("t*t", "t^2");
        this.valueToStringTest("t*t*t", "t^3");
        this.valueToStringTest("t*t*t*t", "t^4");
        this.valueToStringTest("t*t*t*t*t", "1");
    }

    public void testZRoot2Root5() throws Exception {
        Integers integers = new Integers();
        Number[] numberArray = new Number[]{BigInteger.valueOf(-2L), BigInteger.ZERO, BigInteger.ONE};
        Polynomial polynomial = new Polynomial(integers, "t", numberArray);
        AlgebraicExtension algebraicExtension = new AlgebraicExtension((RingI)integers, polynomial);
        Number[] numberArray2 = new Number[]{algebraicExtension.valueOf("-5"), algebraicExtension.valueOf("0"), algebraicExtension.valueOf("1")};
        Polynomial polynomial2 = new Polynomial(algebraicExtension, "s", numberArray2);
        AlgebraicExtension algebraicExtension2 = new AlgebraicExtension((RingI)algebraicExtension, polynomial2);
        this.j = new GroupJep(algebraicExtension2);
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("t", "t");
        this.valueToStringTest("s", "s");
        this.valueToStringTest("t*t", "2");
        this.valueToStringTest("s*s", "5");
        this.valueToStringTest("s*t", "t s");
        this.valueToStringTest("s+t", "s+t");
        this.valueToStringTest("(t-1)*(s-1)", "(t-1) s-t+1");
    }

    public void testZtau() throws Exception {
        Integers integers = new Integers();
        Number[] numberArray = new Number[]{BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), BigInteger.ONE};
        Polynomial polynomial = new Polynomial(integers, "t", numberArray);
        AlgebraicExtension algebraicExtension = new AlgebraicExtension((RingI)integers, polynomial);
        this.j = new GroupJep(algebraicExtension);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("t*t", "t+1");
        this.valueToStringTest("t*t*t", "2 t+1");
        this.valueToStringTest("t*t*t*t", "3 t+2");
        this.valueToStringTest("t*t*t*t*t", "5 t+3");
        this.valueToStringTest("t*t*t*t*t*t", "8 t+5");
        this.valueToStringTest("x=2*t-1", "2 t-1");
        this.valueToStringTest("x*x", "5");
        this.valueToStringTest("-t", "-t");
        this.valueToStringTest("1-t", "-t+1");
        this.valueToStringTest("t*(1-t)", "-1");
    }

    public void testPolynomials() throws Exception {
        Reals reals = new Reals();
        ExtendedFreeGroup extendedFreeGroup = new ExtendedFreeGroup(reals, "x");
        this.j = new GroupJep(extendedFreeGroup);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        Node node = this.j.parse("(x+7.6)*(x+5.8832)*(x-55.12)");
        FreeGroupElement freeGroupElement = (FreeGroupElement)this.j.evaluate(node);
        Number[] numberArray = freeGroupElement.getCoeffs();
        for (int i = 0; i < numberArray.length; ++i) {
            System.out.println("Coeffs [" + i + "] " + numberArray[i]);
        }
        Complex complex = freeGroupElement.calculateComplexValue(new Complex(1.0));
        System.out.println("Value " + complex);
        System.out.println(freeGroupElement.toString());
        this.myAssertEquals("(x+7.6)*(x+5.8832)*(x-55.12): x=1.0", "(-3203.6615424, 0.0)", complex.toString());
        System.out.println("rounding error 7.6+5.8832-55.12 = -41.636799999999994");
        ExtendedFreeGroup extendedFreeGroup2 = new ExtendedFreeGroup(extendedFreeGroup, "y");
        this.j = new GroupJep(extendedFreeGroup2);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        Node node2 = this.j.parse("(x+1)*(y-2)");
        FreeGroupElement freeGroupElement2 = (FreeGroupElement)this.j.evaluate(node2);
        Number[] numberArray2 = freeGroupElement2.getCoeffs();
        for (int i = 0; i < numberArray2.length; ++i) {
            FreeGroupElement freeGroupElement3 = (FreeGroupElement)numberArray2[i];
            Number[] numberArray3 = freeGroupElement3.getCoeffs();
            for (int j = 0; j < numberArray3.length; ++j) {
                System.out.print(numberArray3[j] + "\t");
            }
            System.out.println();
        }
        extendedFreeGroup.setRootVal(new Complex(5.0));
        extendedFreeGroup2.setRootVal(new Complex(4.0));
        System.out.println(freeGroupElement2.toString());
        this.myAssertEquals("(x+1)*(y-2): x=5,y=4", "(12.0, 0.0)", freeGroupElement2.getComplexValue().toString());
        this.valueToStringTest("a=5", "5.0");
        this.valueToStringTest("z=x+y-1", "y+x-1.0");
        this.valueToStringTest("z^a", "y^5+(5.0 x-5.0) y^4+(10.0 x^2-20.0 x+10.0) y^3+(10.0 x^3-30.0 x^2+30.0 x-10.0) y^2+(5.0 x^4-20.0 x^3+30.0 x^2-20.0 x+5.0) y+x^5-5.0 x^4+10.0 x^3-10.0 x^2+5.0 x-1.0");
    }

    public void testPolynomials2() throws Exception {
        Reals reals = new Reals();
        ExtendedFreeGroup extendedFreeGroup = new ExtendedFreeGroup(reals, "x");
        ExtendedFreeGroup extendedFreeGroup2 = new ExtendedFreeGroup(extendedFreeGroup, "y");
        this.j = new GroupJep(extendedFreeGroup2);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        String string = "(3*2) x+34+23+3*2 y+4 x";
        Node node = this.j.parse(string);
        Object object = this.j.evaluate(node);
        String string2 = object.toString();
        System.out.println(string + " -> " + string2);
        String string3 = "6x+3y+4x+3(15x+7y)+40";
        Node node2 = this.j.parse(string3);
        Object object2 = this.j.evaluate(node2);
        String string4 = object2.toString();
        System.out.println(string3 + " -> " + string4);
    }

    public void testPolynomialCreator() throws Exception {
        Reals reals = new Reals();
        FreeGroup freeGroup = new FreeGroup(reals, "x");
        JEP jEP = new JEP();
        jEP.addStandardConstants();
        jEP.addStandardFunctions();
        jEP.setAllowUndeclared(true);
        Node node = jEP.parse("(x+7.6)*(x+5.8832)*(x-55.12)");
        PolynomialVisitor polynomialVisitor = new PolynomialVisitor(jEP);
        Polynomial polynomial = polynomialVisitor.calcPolynomial(node, freeGroup);
        Number[] numberArray = polynomial.getCoeffs();
        for (int i = 0; i < numberArray.length; ++i) {
            System.out.println("Coeffs [" + i + "] " + numberArray[i]);
        }
    }

    public void testBad() throws ParseException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

