/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class MRpTest
extends TestCase {
    MatrixJep mj;
    public static final boolean SHOW_BAD = false;
    String[][] matStrs = new String[10][10];
    String[] vecStrs = new String[10];
    boolean TESTALL = false;
    static /* synthetic */ Class class$org$lsmp$djepJUnit$MRpTest;

    public MRpTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$MRpTest == null ? (class$org$lsmp$djepJUnit$MRpTest = MRpTest.class$("org.lsmp.djepJUnit.MRpTest")) : class$org$lsmp$djepJUnit$MRpTest);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$MRpTest == null ? (class$org$lsmp$djepJUnit$MRpTest = MRpTest.class$("org.lsmp.djepJUnit.MRpTest")) : class$org$lsmp$djepJUnit$MRpTest);
        testSuite.run(new TestResult());
    }

    protected void setUp() {
        int n;
        int n2;
        this.mj = new MatrixJep();
        this.mj.addStandardConstants();
        this.mj.addStandardFunctions();
        this.mj.addComplex();
        this.mj.setAllowAssignment(true);
        this.mj.setAllowUndeclared(true);
        this.mj.setImplicitMul(true);
        this.mj.addStandardDiffRules();
        for (n2 = 2; n2 <= 9; ++n2) {
            for (n = 2; n <= 9; ++n) {
                int n3 = 1;
                StringBuffer stringBuffer = new StringBuffer("[");
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("[");
                    for (int j = 0; j < n; ++j) {
                        if (j > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(String.valueOf(n3++));
                    }
                    stringBuffer.append("]");
                }
                stringBuffer.append("]");
                this.matStrs[n2][n] = stringBuffer.toString();
            }
        }
        for (n2 = 2; n2 <= 9; ++n2) {
            n = 1;
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(String.valueOf(n++));
            }
            stringBuffer.append("]");
            this.vecStrs[n2] = stringBuffer.toString();
        }
    }

    public void testGood() {
        MRpTest.assertEquals((int)1, (int)1);
    }

    public void myAssertEquals(String string, String string2, String string3) {
        if (!string2.equals(string3)) {
            System.out.println("Error \"" + string + "\" is \n<" + string2 + "> should be \n<" + string3 + ">");
        }
        MRpTest.assertEquals((String)("<" + string + ">"), (Object)string3, (Object)string2);
        System.out.println("Success: Value of <" + string + "> is <" + string2 + ">");
    }

    public void valueTest(String string, double d) throws ParseException {
        this.valueTest(string, new Double(d));
    }

    public void valueTest(String string, Object object) throws ParseException {
        Node node = this.mj.parse(string);
        Node node2 = this.mj.preprocess(node);
        Object object2 = this.mj.evaluate(node2);
        if (this.mj.hasError()) {
            MRpTest.fail((String)("Evaluation Failure: " + string + this.mj.getErrorInfo()));
        }
        MRpTest.assertEquals((String)("<" + string + ">"), (Object)object, (Object)object2);
        System.out.println("Sucess value of <" + string + "> is " + object2);
    }

    public void valueTest(String string, String string2) throws ParseException {
        Node node = this.mj.parse(string);
        Node node2 = this.mj.preprocess(node);
        Object object = this.mj.evaluate(node2);
        if (this.mj.hasError()) {
            MRpTest.fail((String)("Evaluation Failure: " + string + this.mj.getErrorInfo()));
        }
        MRpTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)object.toString());
        System.out.println("Sucess value of <" + string + "> is " + object.toString());
    }

    public void complexValueTest(String string, Complex complex, double d) throws Exception {
        Node node = this.mj.preprocess(this.mj.parse(string));
        Object object = this.mj.evaluate(node);
        MRpTest.assertTrue((String)("<" + string + "> expected: <" + complex + "> but was <" + object + ">"), (boolean)complex.equals((Complex)object, d));
        System.out.println("Sucess value of <" + string + "> is " + object);
    }

    public Object calcValue(String string) throws ParseException {
        Node node = this.mj.parse(string);
        Node node2 = this.mj.preprocess(node);
        Object object = this.mj.evaluate(node2);
        return object;
    }

    public void simplifyTest(String string, String string2) throws ParseException {
        Node node = this.mj.parse(string);
        Node node2 = this.mj.preprocess(node);
        Node node3 = this.mj.simplify(node2);
        String string3 = this.mj.toString(node3);
        Node node4 = this.mj.parse(string2);
        Node node5 = this.mj.preprocess(node4);
        Node node6 = this.mj.simplify(node5);
        String string4 = this.mj.toString(node6);
        if (!string4.equals(string3)) {
            System.out.println("Error: Value of \"" + string + "\" is \"" + string3 + "\" should be \"" + string4 + "\"");
        }
        MRpTest.assertEquals((String)("<" + string + ">"), (Object)string4, (Object)string3);
        System.out.println("Sucess: Value of \"" + string + "\" is \"" + string3 + "\"");
    }

    public void simplifyTestString(String string, String string2) throws ParseException {
        Node node = this.mj.parse(string);
        Node node2 = this.mj.preprocess(node);
        String string3 = this.mj.toString(node2);
        if (!string2.equals(string3)) {
            System.out.println("Error: Value of \"" + string + "\" is \"" + string3 + "\" should be \"" + string2 + "\"");
        }
        MRpTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)string3);
        System.out.println("Sucess: Value of \"" + string + "\" is \"" + string3 + "\"");
    }

    void rpTest(String[] stringArray, String string) throws ParseException {
        Object object;
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("eqns " + stringArray[i]);
            object = this.mj.simplify(this.mj.preprocess(this.mj.parse(stringArray[i])));
            this.mj.evaluate((Node)object);
        }
        Node node = this.mj.simplify(this.mj.preprocess(this.mj.parse(string)));
        object = new MRpEval(this.mj);
        MRpCommandList mRpCommandList = ((MRpEval)object).compile(node);
        MRpRes mRpRes = ((MRpEval)object).evaluate(mRpCommandList);
        MatrixValueI matrixValueI = mRpRes.toVecMat();
        Object object2 = this.mj.evaluateRaw(node);
        if (this.mj.hasError()) {
            MRpTest.fail((String)("Evaluation Failure: " + string + this.mj.getErrorInfo()));
        }
        this.myAssertEquals("<" + string + ">", mRpRes.toString(), object2.toString());
        if (!matrixValueI.equals(object2)) {
            MRpTest.fail((String)("Expected <" + object2 + "> found <" + matrixValueI + ">"));
        }
        if (mRpRes.getDims().is1D()) {
            double[] dArray = (double[])mRpRes.toArray();
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] == (Double)((MVector)object2).getEle(i)) continue;
                MRpTest.fail((String)"Problem with toArray");
            }
        } else if (mRpRes.getDims().is2D()) {
            double[][] dArray = (double[][])mRpRes.toArray();
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[i].length; ++j) {
                    if (dArray[i][j] == (Double)((Matrix)object2).getEle(i, j)) continue;
                    MRpTest.fail((String)"Problem with toArray");
                }
            }
        }
        ((MRpEval)object).cleanUp();
    }

    void rpTest2(String[] stringArray) throws ParseException {
        Object object;
        int n;
        Node[] nodeArray = new Node[stringArray.length];
        MatrixValueI[] matrixValueIArray = new MatrixValueI[stringArray.length];
        MRpEval mRpEval = new MRpEval(this.mj);
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println("eqns " + stringArray[n]);
            nodeArray[n] = this.mj.simplify(this.mj.preprocess(this.mj.parse(stringArray[n])));
            object = mRpEval.compile(nodeArray[n]);
            MRpRes mRpRes = mRpEval.evaluate((MRpCommandList)object);
            matrixValueIArray[n] = mRpRes.toVecMat();
            System.out.println("<" + stringArray[n] + "> " + mRpRes.toString());
        }
        for (n = 0; n < stringArray.length; ++n) {
            object = this.mj.evaluateRaw(nodeArray[n]);
            if (matrixValueIArray[n].equals(object)) continue;
            MRpTest.fail((String)("Expected <" + object + "> found <" + matrixValueIArray[n] + ">"));
        }
        mRpEval.cleanUp();
    }

    public void testRp() throws ParseException {
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y");
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y+y");
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y-y");
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y+y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*x");
        this.rpTest(new String[0], "[[1,2,3],[4,5,6],[7,8,9]]*[[1,2,3],[4,5,6],[7,8,9]]");
        this.rpTest(new String[]{"y=[1,2]"}, "y+y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y+y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "y+y");
        this.rpTest(new String[]{"y=[1,2]"}, "-y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "-y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "-y");
        this.rpTest(new String[]{"y=[1,2]"}, "y-y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y-y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "y-y");
        this.rpTest(new String[]{"y=[1,2]"}, "y*3");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y*3");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "y*3");
        this.rpTest(new String[]{"y=[1,2]"}, "5*y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "5*y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "5*y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y . y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y^^y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y*y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y+y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y-y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y*y+y");
        this.rpTest(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "y*x");
        this.rpTest(new String[0], "1*2*3+4*5*6+7*8*9");
        this.rpTest(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
    }

    public void testRpAllDim() throws ParseException {
        for (int i = 2; i <= 4; ++i) {
            for (int j = 2; j <= 4; ++j) {
                int n = 1;
                StringBuffer stringBuffer = new StringBuffer("x=[");
                for (int k = 0; k < i; ++k) {
                    if (k > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("[");
                    for (int i2 = 0; i2 < j; ++i2) {
                        if (i2 > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(String.valueOf(n++));
                    }
                    stringBuffer.append("]");
                }
                stringBuffer.append("]");
                String string = stringBuffer.toString();
                this.rpTest(new String[]{string}, "x+x");
                this.rpTest(new String[]{string}, "x-x");
                this.rpTest(new String[]{string}, "3*x");
                this.rpTest(new String[]{string}, "x*5");
                this.rpTest(new String[]{string}, "-x");
            }
        }
    }

    public void testMul() throws ParseException {
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][4]}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][2]}, "y*x");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[3][2]}, "y*x");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[4][2]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[2][3]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][3]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[4][3]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[2][4]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[3][4]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][4]}, "y*x");
        this.rpTest(new String[]{"x=" + this.matStrs[2][2], "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][2], "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][2], "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][3], "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][3], "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][3], "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][4], "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][4], "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][4], "y=" + this.matStrs[4][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][2], "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][2], "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][2], "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][3], "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][3], "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][3], "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][4], "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][4], "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][4], "y=" + this.matStrs[4][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][2], "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][2], "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][2], "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][3], "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][3], "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][3], "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][4], "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][4], "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][4], "y=" + this.matStrs[4][4]}, "x*y");
    }

    public void testAssign() throws ParseException {
        this.rpTest2(new String[]{"x=[[5,6],[7,8]]", "x+x"});
        this.rpTest2(new String[]{"x=[5,6]", "x+x"});
        this.rpTest2(new String[]{"x=[5,6,7]", "x+x"});
        this.rpTest2(new String[]{"x=[5,6,7,8]", "x+x"});
        this.rpTest2(new String[]{"x=5", "x+x"});
        for (int i = 2; i <= 4; ++i) {
            for (int j = 2; j <= 4; ++j) {
                this.rpTest2(new String[]{"x=" + this.matStrs[i][j], "x+x"});
            }
        }
    }

    public void testLogical() throws ParseException {
        this.rpTest2(new String[]{"1&&1", "1&&0", "0&&0", "0&&1", "3.14&&1"});
        this.rpTest2(new String[]{"1||1", "1||0", "0||0", "0||1", "3.14||0"});
        this.rpTest2(new String[]{"!0", "!1", "!3.14", "!-3.14"});
        this.rpTest2(new String[]{"1>1", "1>0", "0>0", "0>1", "3.14>1"});
        this.rpTest2(new String[]{"1<1", "1<0", "0<0", "0<1", "3.14<1"});
        this.rpTest2(new String[]{"1>=1", "1>=0", "0>=0", "0>=1", "3.14>=1"});
        this.rpTest2(new String[]{"1<=1", "1<=0", "0<=0", "0<=1", "3.14<=1"});
        this.rpTest2(new String[]{"1==1", "1==0", "0==0", "0==1", "3.14==1"});
        this.rpTest2(new String[]{"1!=1", "1!=0", "0!=0", "0!=1", "3.14!=1"});
        this.rpTest2(new String[]{"[1,2]==[1,2]"});
        this.rpTest2(new String[]{"[1,2]!=[1,2]"});
        this.rpTest2(new String[]{"[1,2]==[5,6]"});
        this.rpTest2(new String[]{"[1,2]!=[5,6]"});
        this.rpTest2(new String[]{"[1,2,3]==[1,2,3]"});
        this.rpTest2(new String[]{"[1,2,3]!=[1,2,3]"});
        this.rpTest2(new String[]{"[1,2,3]==[5,6,7]"});
        this.rpTest2(new String[]{"[1,2,3]!=[5,6,7]"});
        this.rpTest2(new String[]{"[1,2,3]==[1,2,4]"});
        this.rpTest2(new String[]{"[1,2,3]!=[1,2,4]"});
        this.rpTest2(new String[]{"[1,2,3,4]==[1,2,3,4]"});
        this.rpTest2(new String[]{"[1,2,3,4]!=[1,2,3,4]"});
        this.rpTest2(new String[]{"[1,2,3,4]==[5,6,7,8]"});
        this.rpTest2(new String[]{"[1,2,3,4]!=[5,6,7,8]"});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
    }

    public void testVn() throws ParseException {
        this.rpTest2(new String[]{"x=[5,6,7,8,9]", "x+x", "x-x", "2*x", "x*3", "x.x"});
        this.rpTest2(new String[]{"x=[[1,2,3,4,5],[5,6,7,8,9]]", "x+x", "x-x", "2*x", "x*3"});
        this.rpTest2(new String[]{"x=[[1,2],[3,4]]", "y=[[1,2,3,4,5],[5,6,7,8,9]]", "x*y"});
        this.rpTest2(new String[]{"x=[[1,2],[3,4]]", "y=[[1,2],[3,4],[5,6],[7,8],[9,10]]", "y*x"});
        this.rpTest2(new String[]{"x=[[1,2,3,4,5],[5,6,7,8,9]]", "y=[[1,2],[3,4],[5,6],[7,8],[9,10]]", "y*x"});
        if (this.TESTALL) {
            int n;
            int n2;
            for (n2 = 2; n2 < 10; ++n2) {
                for (n = 2; n < 10; ++n) {
                    for (int i = 2; i < 10; ++i) {
                        System.out.println("\n[" + n2 + "," + n + "]*[" + n + "," + i + "]");
                        this.rpTest2(new String[]{"x=" + this.matStrs[n2][n], "y=" + this.matStrs[n][i], "x*y"});
                    }
                }
            }
            for (n2 = 2; n2 < 10; ++n2) {
                for (n = 2; n < 10; ++n) {
                    System.out.println("\n[" + n2 + "," + n + "]*[" + n + "]");
                    this.rpTest2(new String[]{"x=" + this.matStrs[n2][n], "y=" + this.vecStrs[n], "x*y"});
                }
            }
            for (n2 = 2; n2 < 10; ++n2) {
                for (n = 2; n < 10; ++n) {
                    System.out.println("\n[" + n2 + "]*[" + n2 + "," + n + "]");
                    this.rpTest2(new String[]{"x=" + this.vecStrs[n2], "y=" + this.matStrs[n2][n], "x*y"});
                }
            }
        }
    }

    public void testFun() throws ParseException {
        this.rpTest2(new String[]{"x=5", "y=4", "x/y", "x%y", "x^y"});
        this.rpTest2(new String[]{"x=0.5", "cos(x)", "sin(x)", "tan(x)", "asin(x)", "acos(x)", "atan(x)"});
        this.rpTest2(new String[]{"x=0.5", "cosh(x)", "sinh(x)", "tanh(x)", "asinh(x)", "acosh(x+1)", "atanh(x)"});
        this.rpTest2(new String[]{"x=0.5", "sqrt(x)", "ln(x)", "log(x)", "exp(x)", "abs(x)"});
        this.rpTest2(new String[]{"x=0.5", "sec(x)", "cosec(x)", "cot(x)"});
    }

    public void testUndecVar() throws ParseException {
        this.mj.setAllowUndeclared(true);
        MRpEval mRpEval = new MRpEval(this.mj);
        Node node = this.mj.parse("zap * gosh");
        Node node2 = this.mj.preprocess(node);
        mRpEval.compile(node2);
    }

    public void testAssignDiff() throws ParseException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

